/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri.test;

import edu.rit.mri.SpinSignal;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.NonNegativeLeastSquares;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.io.File;
import java.util.Scanner;

public class Test03 {
    private Test03() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        if (stringArray.length != 3) {
            Test03.usage();
        }
        File file = new File(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        double d = Double.parseDouble(stringArray[2]);
        ListXYSeries listXYSeries = new ListXYSeries();
        listXYSeries.add(new Scanner(file));
        int n4 = listXYSeries.length();
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = (double)(i + 1) / (double)n3 * d;
        }
        NonNegativeLeastSquares nonNegativeLeastSquares = new NonNegativeLeastSquares(n4, n3);
        for (n2 = 0; n2 < n4; ++n2) {
            double[] dArray2 = nonNegativeLeastSquares.a[n2];
            double d2 = listXYSeries.x(n2);
            for (n = 0; n < n3; ++n) {
                dArray2[n] = SpinSignal.S(dArray[n], d2);
            }
            nonNegativeLeastSquares.b[n2] = listXYSeries.y(n2);
        }
        nonNegativeLeastSquares.solve();
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.print(dArray[n2]);
            System.out.print('\t');
            System.out.print(nonNegativeLeastSquares.x[n2]);
            System.out.println();
        }
        Plot plot = new Plot();
        plot.xAxisLength(1200.0).xAxisMajorDivisions(20).yAxisLength(600.0).yAxisMajorDivisions(10).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(listXYSeries);
        double d3 = 0.0;
        ListXYSeries listXYSeries2 = new ListXYSeries();
        for (n = 0; n < listXYSeries.length(); ++n) {
            double d4 = listXYSeries.x(n);
            double d5 = 0.0;
            for (int i = 0; i < n3; ++i) {
                d5 += SpinSignal.S(nonNegativeLeastSquares.x[i], dArray[i], d4);
            }
            double d6 = d5 - listXYSeries.y(n);
            d3 += d6 * d6;
            listXYSeries2.add(d4, d5);
        }
        System.out.println("chi^2 = " + d3);
        plot.seriesDots(null).seriesColor(Color.RED).seriesStroke(Strokes.solid(1.0)).xySeries(listXYSeries2);
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.Test03 <datafile> <N> <Rmax>");
        System.err.println("<datafile> = File containing t and S(t) values");
        System.err.println("<N> = Number of model spin signals");
        System.err.println("<Rmax> = Maximum spin relaxation rate");
        System.exit(1);
    }
}

