/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.IORequest;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.pj.CommRequest;
import edu.rit.pj.CommStatus;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.CommPattern;
import edu.rit.pj.cluster.JobBackend;
import edu.rit.pj.cluster.JobFrontend;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;

public class Comm {
    private static Comm theWorldCommunicator;
    private static Comm theFrontendCommunicator;
    private int mySize;
    private int myRank;
    private String myHost;
    private int mySizePowerOf2;
    private ChannelGroup myChannelGroup;
    private InetSocketAddress[] myAddressForRank;
    private Channel[] myChannelForRank;
    private int[][] myBroadcastTree;

    private Comm(int n, int n2, String string, ChannelGroup channelGroup, InetSocketAddress[] inetSocketAddressArray) {
        int n3;
        this.mySize = n;
        this.myRank = n2;
        this.myHost = string;
        this.myChannelGroup = channelGroup;
        for (n3 = 1; n3 <= n; n3 <<= 1) {
        }
        this.mySizePowerOf2 = n3 >>> 1;
        this.myChannelGroup.setChannelGroupId(n2);
        this.myChannelGroup.setConnectListener(new ConnectListener(){

            public void nearEndConnected(ChannelGroup channelGroup, Channel channel) throws IOException {
            }

            public void farEndConnected(ChannelGroup channelGroup, Channel channel) throws IOException {
                Comm.this.doFarEndConnected(channel);
            }
        });
        this.myAddressForRank = inetSocketAddressArray;
        this.myChannelForRank = new Channel[n];
        this.myChannelForRank[this.myRank] = channelGroup.loopbackChannel();
        if (this.mySize > 1) {
            this.myChannelGroup.startListening();
        }
    }

    public static void init(String[] stringArray) throws IOException {
        if (stringArray == null) {
            throw new NullPointerException("Comm.init(): args is null");
        }
        JobBackend jobBackend = JobBackend.getJobBackend();
        if (jobBackend == null) {
            String string = System.getProperty("user.name");
            int n = PJProperties.getPjNn();
            int n2 = PJProperties.getPjNp();
            int n3 = PJProperties.getPjNt();
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - 1];
            if (!stackTraceElement.getMethodName().equals("main")) {
                throw new IllegalStateException("Comm.init(): Not called from main program");
            }
            String string2 = stackTraceElement.getClassName();
            JobFrontend jobFrontend = null;
            try {
                jobFrontend = new JobFrontend(string, n, n2, n3, bl, string2, stringArray);
                jobFrontend.run();
                System.exit(0);
            }
            catch (JobSchedulerException jobSchedulerException) {
                System.err.println("No Job Scheduler at " + PJProperties.getPjHost() + ":" + PJProperties.getPjPort() + ", running in this (one) process");
                theWorldCommunicator = new Comm(1, 0, "<unknown>", new ChannelGroup(), new InetSocketAddress[]{new InetSocketAddress(0)});
            }
        } else {
            theWorldCommunicator = new Comm(jobBackend.getK(), jobBackend.getRank(), jobBackend.getBackendHost(), jobBackend.getWorldChannelGroup(), jobBackend.getWorldAddress());
        }
    }

    public static Comm world() {
        if (theWorldCommunicator != null) {
            return theWorldCommunicator;
        }
        if (JobBackend.getJobBackend() != null) {
            throw new IllegalStateException("Comm.world(): Didn't call Comm.init()");
        }
        throw new IllegalStateException("Comm.world(): World communicator doesn't exist in job frontend process");
    }

    public int size() {
        return this.mySize;
    }

    public int rank() {
        return this.myRank;
    }

    public String host() {
        return this.myHost;
    }

    public Comm createComm(boolean bl) throws IOException {
        return this.createComm(bl, 0);
    }

    public Comm createComm(boolean bl, int n) throws IOException {
        InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[this.mySize];
        Buf[] bufArray = ObjectBuf.sliceBuffers(inetSocketAddressArray, new Range(0, this.mySize - 1).subranges(this.mySize));
        ChannelGroup channelGroup = null;
        InetSocketAddress inetSocketAddress = null;
        if (bl) {
            channelGroup = new ChannelGroup(new InetSocketAddress(this.myChannelGroup.listenAddress().getAddress(), 0));
            inetSocketAddressArray[this.myRank] = inetSocketAddress = channelGroup.listenAddress();
        }
        this.allGather(n, bufArray[this.myRank], bufArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < this.mySize; ++i) {
            if (inetSocketAddressArray[i] == null) {
                ++n2;
                continue;
            }
            if (i == this.myRank) {
                n4 = i - n2;
            }
            inetSocketAddressArray[i - n2] = inetSocketAddressArray[i];
            ++n3;
        }
        if (n3 == 0) {
            throw new IOException("Comm.createComm(): No processes in communicator");
        }
        if (bl) {
            return new Comm(n3, n4, this.myHost, channelGroup, inetSocketAddressArray);
        }
        return null;
    }

    public void send(int n, Buf buf) throws IOException {
        this.send(n, 0, buf);
    }

    public void send(int n, int n2, Buf buf) throws IOException {
        this.myChannelGroup.send(this.getChannel(n), n2, buf);
    }

    public CommRequest send(int n, Buf buf, CommRequest commRequest) throws IOException {
        return this.send(n, 0, buf, commRequest);
    }

    public CommRequest send(int n, int n2, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = new IORequest();
        commRequest2.myRecvRequest = null;
        this.myChannelGroup.sendNoWait(this.getChannel(n), n2, buf, commRequest2.mySendRequest);
        return commRequest2;
    }

    public CommStatus receive(Integer n, Buf buf) throws IOException {
        return this.receive(n, 0, buf);
    }

    public CommStatus receive(Integer n, int n2, Buf buf) throws IOException {
        Status status;
        if (n == null) {
            for (int i = 0; i < this.mySize; ++i) {
                this.ensureChannel(i);
            }
            status = this.myChannelGroup.receive(null, n2, buf);
        } else {
            status = this.myChannelGroup.receive(this.getChannel(n), n2, buf);
        }
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommStatus receive(Integer n, Range range, Buf buf) throws IOException {
        Status status;
        if (n == null) {
            for (int i = 0; i < this.mySize; ++i) {
                this.ensureChannel(i);
            }
            status = this.myChannelGroup.receive(null, range, buf);
        } else {
            status = this.myChannelGroup.receive(this.getChannel(n), range, buf);
        }
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest receive(Integer n, Buf buf, CommRequest commRequest) throws IOException {
        return this.receive(n, 0, buf, commRequest);
    }

    public CommRequest receive(Integer n, int n2, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = null;
        commRequest2.myRecvRequest = new IORequest();
        if (n == null) {
            for (int i = 0; i < this.mySize; ++i) {
                this.ensureChannel(i);
            }
            this.myChannelGroup.receiveNoWait(null, n2, buf, commRequest2.myRecvRequest);
        } else {
            this.myChannelGroup.receiveNoWait(this.getChannel(n), n2, buf, commRequest2.myRecvRequest);
        }
        return commRequest2;
    }

    public CommRequest receive(Integer n, Range range, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = null;
        commRequest2.myRecvRequest = new IORequest();
        if (n == null) {
            for (int i = 0; i < this.mySize; ++i) {
                this.ensureChannel(i);
            }
            this.myChannelGroup.receiveNoWait(null, range, buf, commRequest2.myRecvRequest);
        } else {
            this.myChannelGroup.receiveNoWait(this.getChannel(n), range, buf, commRequest2.myRecvRequest);
        }
        return commRequest2;
    }

    public CommStatus sendReceive(int n, Buf buf, int n2, Buf buf2) throws IOException {
        return this.sendReceive(n, 0, buf, n2, 0, buf2);
    }

    public CommStatus sendReceive(int n, int n2, Buf buf, int n3, int n4, Buf buf2) throws IOException {
        IORequest iORequest = new IORequest();
        this.myChannelGroup.sendNoWait(this.getChannel(n), n2, buf, iORequest);
        IORequest iORequest2 = new IORequest();
        this.myChannelGroup.receiveNoWait(this.getChannel(n3), n4, buf2, iORequest2);
        iORequest.waitForFinish();
        Status status = iORequest2.waitForFinish();
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest sendReceive(int n, Buf buf, int n2, Buf buf2, CommRequest commRequest) throws IOException {
        return this.sendReceive(n, 0, buf, n2, 0, buf2, commRequest);
    }

    public CommRequest sendReceive(int n, int n2, Buf buf, int n3, int n4, Buf buf2, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = new IORequest();
        this.myChannelGroup.sendNoWait(this.getChannel(n), n2, buf, commRequest2.mySendRequest);
        commRequest2.myRecvRequest = new IORequest();
        this.myChannelGroup.receiveNoWait(this.getChannel(n3), n4, buf2, commRequest2.myRecvRequest);
        return commRequest2;
    }

    public void floodSend(Buf buf) throws IOException {
        this.floodSend(0, buf, null).waitForFinish();
    }

    public void floodSend(int n, Buf buf) throws IOException {
        this.floodSend(n, buf, null).waitForFinish();
    }

    public CommRequest floodSend(Buf buf, CommRequest commRequest) throws IOException {
        return this.floodSend(0, buf, commRequest);
    }

    public CommRequest floodSend(int n, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = new IORequest();
        commRequest2.myRecvRequest = null;
        this.myChannelGroup.sendNoWait(this.getChannel(0), n, buf, commRequest2.mySendRequest);
        return commRequest2;
    }

    public CommStatus floodReceive(Buf buf) throws IOException {
        return this.floodReceive(0, buf, null).waitForFinish();
    }

    public CommStatus floodReceive(Integer n, Buf buf) throws IOException {
        return this.floodReceive(n, buf, null).waitForFinish();
    }

    public CommRequest floodReceive(Buf buf, CommRequest commRequest) throws IOException {
        return this.floodReceive(0, buf, commRequest);
    }

    public CommRequest floodReceive(Integer n, Buf buf, CommRequest commRequest) throws IOException {
        int[] nArray = this.getBroadcastTree(0);
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = null;
        commRequest2.myRecvRequest = new FloodReceiveIORequest(nArray);
        if (this.myRank == 0) {
            for (int i = 0; i < this.mySize; ++i) {
                this.ensureChannel(i);
            }
            this.myChannelGroup.receiveNoWait(null, n, buf, commRequest2.myRecvRequest);
        } else {
            for (int i = 1; i < nArray.length; ++i) {
                this.ensureChannel(nArray[i]);
            }
            this.myChannelGroup.receiveNoWait(this.getChannel(nArray[0]), n, buf, commRequest2.myRecvRequest);
        }
        return commRequest2;
    }

    public void broadcast(int n, Buf buf) throws IOException {
        this.broadcast(n, 0, buf);
    }

    public void broadcast(int n, int n2, Buf buf) throws IOException {
        int n3;
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.broadcast(): root = " + n + " out of bounds");
        }
        if (this.mySize == 1) {
            return;
        }
        int[] nArray = this.getBroadcastTree(n);
        int n4 = nArray.length;
        int n5 = nArray[0];
        if (n5 != -1) {
            this.myChannelGroup.receive(this.getChannel(n5), n2, buf);
        }
        IORequest[] iORequestArray = new IORequest[n4];
        for (n3 = 1; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            iORequestArray[n3] = new IORequest();
            this.myChannelGroup.sendNoWait(this.getChannel(n6), n2, buf, iORequestArray[n3]);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            iORequestArray[n3].waitForFinish();
        }
    }

    public void scatter(int n, Buf[] bufArray, Buf buf) throws IOException {
        this.scatter(n, 0, bufArray, buf);
    }

    public void scatter(int n, int n2, Buf[] bufArray, Buf buf) throws IOException {
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.scatter(): root = " + n + " out of bounds");
        }
        if (this.myRank == n) {
            int n3;
            IORequest[] iORequestArray = new IORequest[this.mySize];
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3] = new IORequest();
                this.myChannelGroup.sendNoWait(this.getChannel(n3), n2, bufArray[n3], iORequestArray[n3]);
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3] = new IORequest();
                this.myChannelGroup.sendNoWait(this.getChannel(n3), n2, bufArray[n3], iORequestArray[n3]);
            }
            buf.copy(bufArray[this.myRank]);
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
        } else {
            this.myChannelGroup.receive(this.getChannel(n), n2, buf);
        }
    }

    public void gather(int n, Buf buf, Buf[] bufArray) throws IOException {
        this.gather(n, 0, buf, bufArray);
    }

    public void gather(int n, int n2, Buf buf, Buf[] bufArray) throws IOException {
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.gather(): root = " + n + " out of bounds");
        }
        if (this.myRank == n) {
            int n3;
            IORequest[] iORequestArray = new IORequest[this.mySize];
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3] = new IORequest();
                this.myChannelGroup.receiveNoWait(this.getChannel(n3), n2, bufArray[n3], iORequestArray[n3]);
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3] = new IORequest();
                this.myChannelGroup.receiveNoWait(this.getChannel(n3), n2, bufArray[n3], iORequestArray[n3]);
            }
            bufArray[this.myRank].copy(buf);
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
        } else {
            this.myChannelGroup.send(this.getChannel(n), n2, buf);
        }
    }

    public void allGather(Buf buf, Buf[] bufArray) throws IOException {
        this.allGather(0, buf, bufArray);
    }

    public void allGather(int n, Buf buf, Buf[] bufArray) throws IOException {
        int n2 = (this.myRank - 1 + this.mySize) % this.mySize;
        int n3 = (this.myRank + 1) % this.mySize;
        bufArray[this.myRank].copy(buf);
        for (int i = 1; i < this.mySize; ++i) {
            this.sendReceive(n2, n, bufArray[(this.myRank + i - 1) % this.mySize], n3, n, bufArray[(this.myRank + i) % this.mySize]);
        }
    }

    public void reduce(int n, Buf buf, Op op) throws IOException {
        this.reduce(n, 0, buf, op);
    }

    public void reduce(int n, int n2, Buf buf, Op op) throws IOException {
        int n3;
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.reduce(): root = " + n + " out of bounds");
        }
        if (this.mySize == 1) {
            return;
        }
        int[] nArray = this.getBroadcastTree(n);
        int n4 = nArray.length;
        Buf buf2 = buf.getReductionBuf(op);
        for (n3 = n4 - 1; n3 >= 1; --n3) {
            int n5 = nArray[n3];
            this.myChannelGroup.receive(this.getChannel(n5), n2, buf2);
        }
        n3 = nArray[0];
        if (n3 != -1) {
            this.myChannelGroup.send(this.getChannel(n3), n2, buf);
        }
    }

    public void allReduce(Buf buf, Op op) throws IOException {
        this.allReduce(0, buf, op);
    }

    public void allReduce(int n, Buf buf, Op op) throws IOException {
        if (this.mySize == 1) {
            return;
        }
        int n2 = this.mySizePowerOf2;
        if (this.myRank >= n2) {
            int n3 = this.myRank - n2;
            this.send(n3, n, buf);
            this.receive((Integer)n3, n, buf);
        } else {
            Buf buf2 = buf.getTemporaryBuf();
            Buf buf3 = buf.getReductionBuf(op);
            int n4 = this.myRank + n2;
            if (n4 < this.mySize) {
                this.receive((Integer)n4, n, buf3);
            }
            for (int i = 1; i < n2; i <<= 1) {
                int n5 = this.myRank ^ i;
                this.sendReceive(n5, n, buf, n5, n, buf2);
                buf3.copy(buf2);
            }
            if (n4 < this.mySize) {
                this.send(n4, n, buf);
            }
        }
    }

    public void allToAll(Buf[] bufArray, Buf[] bufArray2) throws IOException {
        this.allToAll(0, bufArray, bufArray2);
    }

    public void allToAll(int n, Buf[] bufArray, Buf[] bufArray2) throws IOException {
        int n2;
        bufArray2[this.myRank].copy(bufArray[this.myRank]);
        CommRequest[] commRequestArray = new CommRequest[this.mySize];
        for (n2 = 1; n2 < this.mySize; ++n2) {
            int n3 = (this.myRank + n2) % this.mySize;
            int n4 = (this.myRank - n2 + this.mySize) % this.mySize;
            commRequestArray[n2] = this.sendReceive(n3, n, bufArray[n3], n4, n, bufArray2[n4], null);
        }
        for (n2 = 1; n2 < this.mySize; ++n2) {
            commRequestArray[n2].waitForFinish();
        }
    }

    public void scan(Buf buf, Op op) throws IOException {
        this.scan(0, buf, op);
    }

    public void scan(int n, Buf buf, Op op) throws IOException {
        if (this.mySize == 1) {
            return;
        }
        Buf buf2 = buf.getTemporaryBuf();
        Buf buf3 = buf.getReductionBuf(op);
        int n2 = 1;
        while (true) {
            boolean bl;
            int n3 = this.myRank + n2;
            int n4 = this.myRank - n2;
            boolean bl2 = 0 <= n3 && n3 < this.mySize;
            boolean bl3 = bl = 0 <= n4 && n4 < this.mySize;
            if (bl2 && bl) {
                this.sendReceive(n3, n, buf, n4, n, buf2);
                buf3.copy(buf2);
            } else if (bl) {
                this.receive((Integer)n4, n, buf3);
            } else {
                if (!bl2) break;
                this.send(n3, n, buf);
            }
            n2 <<= 1;
        }
    }

    public void exclusiveScan(Buf buf, Op op, Object object) throws IOException {
        this.exclusiveScan(0, buf, op, object);
    }

    public void exclusiveScan(int n, Buf buf, Op op, Object object) throws IOException {
        if (this.myRank == 0) {
            boolean bl;
            int n2 = 1;
            boolean bl2 = bl = n2 < this.mySize;
            if (bl) {
                this.send(n2, n, buf);
            }
            buf.fill(object);
        } else {
            boolean bl;
            Buf buf2 = buf.getTemporaryBuf();
            Buf buf3 = buf.getReductionBuf(op);
            int n3 = this.myRank + 1;
            int n4 = this.myRank - 1;
            boolean bl3 = bl = 0 <= n3 && n3 < this.mySize;
            if (bl) {
                this.sendReceive(n3, n, buf, n4, n, buf2);
                buf.copy(buf2);
            } else {
                this.receive((Integer)n4, n, buf);
            }
            int n5 = 1;
            while (true) {
                boolean bl4;
                n3 = this.myRank + n5;
                n4 = this.myRank - n5;
                bl = 1 <= n3 && n3 < this.mySize;
                boolean bl5 = bl4 = 1 <= n4 && n4 < this.mySize;
                if (bl && bl4) {
                    this.sendReceive(n3, n, buf, n4, n, buf2);
                    buf3.copy(buf2);
                } else if (bl4) {
                    this.receive((Integer)n4, n, buf3);
                } else {
                    if (!bl) break;
                    this.send(n3, n, buf);
                }
                n5 <<= 1;
            }
        }
    }

    public void barrier() throws IOException {
        this.barrier(0);
    }

    public void barrier(int n) throws IOException {
        this.allReduce(n, IntegerBuf.emptyBuffer(), IntegerOp.SUM);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Comm(size=");
        stringBuilder.append(this.mySize);
        stringBuilder.append(",rank=");
        stringBuilder.append(this.myRank);
        stringBuilder.append(",backend");
        for (int i = 0; i < this.mySize; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('[');
            stringBuilder.append(i);
            stringBuilder.append("]=");
            stringBuilder.append(this.myAddressForRank[i]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void dump(PrintStream printStream, String string) {
        int n;
        printStream.println();
        printStream.println(string + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        printStream.println(string + "mySize = " + this.mySize);
        printStream.println(string + "myRank = " + this.myRank);
        printStream.println(string + "myHost = " + this.myHost);
        printStream.println(string + "mySizePowerOf2 = " + this.mySizePowerOf2);
        printStream.println(string + "myChannelGroup = " + this.myChannelGroup);
        printStream.println(string + "myAddressForRank:");
        for (n = 0; n < this.myAddressForRank.length; ++n) {
            printStream.println(string + "\t[" + n + "] " + this.myAddressForRank[n]);
        }
        printStream.println(string + "myChannelForRank:");
        for (n = 0; n < this.myChannelForRank.length; ++n) {
            printStream.println(string + "\t[" + n + "] " + this.myChannelForRank[n]);
        }
        printStream.println(string + "myBroadcastTree:");
        for (n = 0; n < this.myBroadcastTree.length; ++n) {
            printStream.print(string + "\t[" + n + "]");
            int[] nArray = this.myBroadcastTree[n];
            if (nArray == null) {
                printStream.print(" null");
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    printStream.print(" " + nArray[i]);
                }
            }
            printStream.println();
        }
        printStream.println();
        this.myChannelGroup.dump(printStream, string);
    }

    private synchronized void doFarEndConnected(Channel channel) throws IOException {
        this.myChannelForRank[Comm.getFarRank((Channel)channel)] = channel;
        this.notifyAll();
    }

    private synchronized void ensureChannel(int n) throws IOException {
        Channel channel = this.myChannelForRank[n];
        if (channel == null && this.myRank < n) {
            this.myChannelForRank[n] = this.myChannelGroup.connect(this.myAddressForRank[n]);
        }
    }

    private synchronized Channel getChannel(int n) throws IOException {
        Channel channel = this.myChannelForRank[n];
        if (channel == null) {
            if (this.myRank < n) {
                this.myChannelForRank[n] = channel = this.myChannelGroup.connect(this.myAddressForRank[n]);
            } else {
                try {
                    while (channel == null) {
                        this.wait();
                        channel = this.myChannelForRank[n];
                    }
                }
                catch (InterruptedException interruptedException) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    interruptedIOException.initCause(interruptedException);
                    throw interruptedIOException;
                }
            }
        }
        return channel;
    }

    static int getFarRank(Channel channel) {
        return channel.farEndChannelGroupId();
    }

    private synchronized int[] getBroadcastTree(int n) {
        int[] nArray;
        if (this.myBroadcastTree == null) {
            this.myBroadcastTree = new int[this.mySize][];
        }
        if ((nArray = this.myBroadcastTree[n]) == null) {
            nArray = CommPattern.broadcastPattern(this.mySize, this.myRank, n);
            this.myBroadcastTree[n] = nArray;
        }
        return nArray;
    }

    private class FloodReceiveIORequest
    extends IORequest {
        private int[] tree;
        private LinkedList<IORequest> myForwardedIORequests = new LinkedList();

        public FloodReceiveIORequest(int[] nArray) {
            this.tree = nArray;
        }

        public synchronized boolean isFinished() throws IOException {
            if (!super.isFinished()) {
                return false;
            }
            for (IORequest iORequest : this.myForwardedIORequests) {
                if (iORequest.isFinished()) continue;
                return false;
            }
            return true;
        }

        public synchronized Status waitForFinish() throws IOException {
            Status status = super.waitForFinish();
            for (IORequest iORequest : this.myForwardedIORequests) {
                iORequest.waitForFinish();
            }
            return status;
        }

        protected synchronized void reportSuccess() {
            try {
                super.reportSuccess();
                int n = this.myStatus.tag;
                int n2 = this.tree.length;
                for (int i = 1; i < n2; ++i) {
                    IORequest iORequest = new IORequest();
                    this.myForwardedIORequests.add(iORequest);
                    Comm.this.myChannelGroup.sendNoWait(Comm.this.getChannel(this.tree[i]), n, this.myBuf, iORequest);
                }
            }
            catch (IOException iOException) {
                this.reportFailure(iOException);
            }
        }
    }
}

