/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.DefaultRandom;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public abstract class Random
implements Serializable {
    private static double D_2_POW_NEG_64;
    private static float F_2_POW_NEG_64;

    protected Random() {
    }

    public static Random getInstance(long l) {
        String string = System.getProperty("pj.prng");
        return string == null ? new DefaultRandom(l) : Random.getInstance(l, string);
    }

    public static Random getInstance(long l, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
            return (Random)constructor.newInstance(l);
        }
        catch (Exception exception) {
            throw new TypeNotPresentException(string, exception);
        }
    }

    public abstract void setSeed(long var1);

    public void skip() {
        this.next();
    }

    public void skip(long l) {
        if (l > 0L) {
            this.next(l);
        }
    }

    public boolean nextBoolean() {
        return this.next() >= 0L;
    }

    public boolean nextBoolean(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextBoolean(): skip = " + l + " illegal");
        }
        return this.next(l) >= 0L;
    }

    public byte nextByte() {
        return (byte)this.next();
    }

    public byte nextByte(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextByte(): skip = " + l + " illegal");
        }
        return (byte)this.next(l);
    }

    public int nextUnsignedByte() {
        return (int)(this.next() & 0xFFL);
    }

    public int nextUnsignedByte(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextUnsignedByte(): skip = " + l + " illegal");
        }
        return (int)(this.next(l) & 0xFFL);
    }

    public char nextCharacter() {
        return (char)this.next();
    }

    public int nextCharacter(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextCharacter(): skip = " + l + " illegal");
        }
        return (char)this.next(l);
    }

    public short nextShort() {
        return (short)this.next();
    }

    public short nextShort(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextShort(): skip = " + l + " illegal");
        }
        return (short)this.next(l);
    }

    public int nextUnsignedShort() {
        return (int)(this.next() & 0xFFFFL);
    }

    public int nextUnsignedShort(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextUnsignedShort(): skip = " + l + " illegal");
        }
        return (int)(this.next(l) & 0xFFFFL);
    }

    public int nextInteger() {
        return (int)this.next();
    }

    public int nextInteger(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextInteger(): skip = " + l + " illegal");
        }
        return (int)this.next(l);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Random.nextInt(): n = " + n + " illegal");
        }
        return (int)Math.floor(this.nextDouble() * (double)n);
    }

    public int nextInt(int n, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException("Random.nextInt(): n = " + n + " illegal");
        }
        return (int)Math.floor(this.nextDouble(l) * (double)n);
    }

    public long nextLong() {
        return this.next();
    }

    public long nextLong(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextLong(): skip = " + l + " illegal");
        }
        return this.next(l);
    }

    public float nextFloat() {
        return (float)this.next() * F_2_POW_NEG_64 + 0.5f;
    }

    public float nextFloat(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextFloat(): skip = " + l + " illegal");
        }
        return (float)this.next(l) * F_2_POW_NEG_64 + 0.5f;
    }

    public double nextDouble() {
        return (double)this.next() * D_2_POW_NEG_64 + 0.5;
    }

    public double nextDouble(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Random.nextDouble(): skip = " + l + " illegal");
        }
        return (double)this.next(l) * D_2_POW_NEG_64 + 0.5;
    }

    protected abstract long next();

    protected abstract long next(long var1);

    static {
        double d = 2.0;
        d *= d;
        d *= d;
        d *= d;
        d *= d;
        d *= d;
        d *= d;
        D_2_POW_NEG_64 = 1.0 / d;
        F_2_POW_NEG_64 = (float)D_2_POW_NEG_64;
    }
}

