/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.geese.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.geese.common.RmiGaggleConnector;
import org.systemsbiology.gaggle.geese.common.actions.ConnectToBossAction;
import org.systemsbiology.gaggle.geese.common.actions.DisconnectFromBossAction;
import org.systemsbiology.gaggle.geese.common.actions.HideGooseAction;
import org.systemsbiology.gaggle.geese.common.actions.ShowGooseAction;
import org.systemsbiology.gaggle.geese.common.actions.UpdateGooseChooserAction;
import org.systemsbiology.gaggle.geese.common.gui.GaggleMenu;
import org.systemsbiology.gaggle.geese.common.gui.GooseChooserComboBox;

public class GuiWidgetFactory {
    private GooseChooserComboBox gooseChooser;
    private JMenu gaggleMenu;
    private ConnectToBossAction connectToBossAction;
    private DisconnectFromBossAction disconnectFromBossAction;
    private UpdateGooseChooserAction updateGooseChooserAction;
    private RmiGaggleConnector connector;
    private JMenuItem connectMenuItem;
    private JMenuItem disconnectMenuItem;
    private JMenuItem updateMenuItem;
    private ShowGooseAction showGooseAction;
    private HideGooseAction hideGooseAction;

    public GuiWidgetFactory(RmiGaggleConnector connector, Goose goose) {
        this.connector = connector;
        this.gooseChooser = new GooseChooserComboBox(goose);
        connector.addListener(this.gooseChooser);
        this.connectToBossAction = new ConnectToBossAction(connector);
        this.disconnectFromBossAction = new DisconnectFromBossAction(connector);
        this.updateGooseChooserAction = new UpdateGooseChooserAction();
        this.updateGooseChooserAction.setGooseChooser(this.gooseChooser);
        this.showGooseAction = new ShowGooseAction();
        connector.addListener(this.showGooseAction);
        this.hideGooseAction = new HideGooseAction();
        connector.addListener(this.hideGooseAction);
        this.gooseChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiWidgetFactory.this.showGooseAction.setTargetGoose(GuiWidgetFactory.this.gooseChooser.getTargetGoose());
                GuiWidgetFactory.this.hideGooseAction.setTargetGoose(GuiWidgetFactory.this.gooseChooser.getTargetGoose());
            }
        });
        this.createGaggleMenu();
    }

    private void createGaggleMenu() {
        this.gaggleMenu = new GaggleMenu(this.connector);
        this.connectMenuItem = new JMenuItem(this.connectToBossAction);
        this.gaggleMenu.add(this.connectMenuItem);
        this.disconnectMenuItem = new JMenuItem(this.disconnectFromBossAction);
        this.gaggleMenu.add(this.disconnectMenuItem);
    }

    public JComboBox getGooseChooser() {
        return this.gooseChooser;
    }

    public JMenu getGaggleMenu() {
        return this.gaggleMenu;
    }

    public Action getUpdateAction() {
        return this.updateGooseChooserAction;
    }

    public Action getConnectAction() {
        return this.connectToBossAction;
    }

    public Action getDisconnectAction() {
        return this.disconnectFromBossAction;
    }

    public Action getShowGooseAction() {
        return this.showGooseAction;
    }

    public Action getHideGooseAction() {
        return this.hideGooseAction;
    }
}

