## ---- echo=FALSE--------------------------------------------------------------
knitr::opts_chunk$set(cache = FALSE,
                        fig.width = 9,
                        message = FALSE,
                        warning = FALSE)

## ----install-bioc,eval=FALSE--------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  

## -----------------------------------------------------------------------------
library(miaSim)
A_normal <- powerlawA(n.species = 4, alpha = 3)

## -----------------------------------------------------------------------------
A_uniform <- randomA(n.species = 10, d = -0.4, min.strength = -0.8,
                        max.strength = 0.8, connectance = 0.5)

## -----------------------------------------------------------------------------
SEobject <- simulateGLV(n.species = 4, A_normal, t.end = 1000)

## -----------------------------------------------------------------------------
Time <- tDyn(t.start = 0, t.end = 100, t.step = 0.5, t.store = 100)
Time$t.index 

## -----------------------------------------------------------------------------

A_uniform <- randomA(n.species = 10, d = -0.4, min.strength = -0.8,
                        max.strength = 0.8, connectance = 0.5)

## -----------------------------------------------------------------------------
SEobject <- simulateGLV(n.species = 4, A_normal, t.start = 0, t.store = 1000)

## -----------------------------------------------------------------------------
Time <- tDyn(t.start = 0, t.end = 100, t.step = 0.5, t.store = 100)
Time$t.index 

## -----------------------------------------------------------------------------

ExampleHubbell <- simulateHubbell(n.species = 8, M = 10, I = 1000, d = 50,
                                    m = 0.02, tend = 100)


## -----------------------------------------------------------------------------
ExampleSOI <- simulateSOI(n.species = 4, I = 1000, A_normal, k=5, com = NULL,
                                            tend = 150, norm = TRUE)

## -----------------------------------------------------------------------------
sessionInfo()

