/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBPropDatabase;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnection
implements IDBConnection {
    protected Connection m_connection;
    protected String m_url;
    protected String m_user;
    protected String m_password;
    protected String m_databaseType = null;
    protected IRDBDriver m_driver = null;

    public DBConnection(String url, String user, String password) {
        this(url, user, password, null);
    }

    public DBConnection(String url, String user, String password, String databaseType) {
        this.m_url = url;
        this.m_user = user;
        this.m_password = password;
        this.setDatabaseType(databaseType);
    }

    public DBConnection(Connection connection) {
        this(connection, null);
    }

    public DBConnection(Connection connection, String databaseType) {
        this.m_connection = connection;
        this.setDatabaseType(databaseType);
    }

    public Connection getConnection() throws SQLException {
        if (this.m_connection == null && this.m_url != null) {
            this.m_connection = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
            this.m_connection.setAutoCommit(true);
        }
        return this.m_connection;
    }

    public void close() throws SQLException {
        if (this.m_driver != null) {
            this.m_driver.close();
            this.m_driver = null;
        }
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public void cleanDB() throws SQLException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        this.m_driver.cleanDB();
    }

    public boolean isFormatOK() {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        return this.m_driver.isDBFormatOK();
    }

    public void setDatabaseProperties(Model dbProperties) throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        this.m_driver.setDatabaseProperties(dbProperties.getGraph());
    }

    public Model getDatabaseProperties() throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        Model resultModel = ModelFactory.createDefaultModel();
        DBConnection.copySpecializedGraphToModel(this.m_driver.getSystemSpecializedGraph(true), resultModel, Triple.ANY);
        return resultModel;
    }

    public Model getDefaultModelProperties() throws RDFRDBException {
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        DBPropGraph defaultProps = this.m_driver.getDefaultModelProperties();
        Model resultModel = ModelFactory.createDefaultModel();
        DBConnection.copySpecializedGraphToModel(this.m_driver.getSystemSpecializedGraph(true), resultModel, Triple.createMatch(defaultProps.getNode(), null, null));
        return resultModel;
    }

    public ExtendedIterator getAllModelNames() throws RDFRDBException {
        ExtendedIterator it;
        SpecializedGraph sg;
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        if ((sg = this.m_driver.getSystemSpecializedGraph(false)) == null) {
            it = new ResultSetIterator();
        } else {
            DBPropDatabase dbprops = new DBPropDatabase(sg);
            it = dbprops.getAllGraphNames();
        }
        return it;
    }

    public boolean containsModel(String name) throws RDFRDBException {
        SpecializedGraph sg;
        boolean res = false;
        if (this.m_driver == null) {
            this.m_driver = this.getDriver();
        }
        if ((sg = this.m_driver.getSystemSpecializedGraph(false)) != null) {
            DBPropGraph g = DBPropGraph.findPropGraphByName(sg, name);
            res = g == null ? false : g.isDBPropGraphOk(name);
        }
        return res;
    }

    public boolean containsDefaultModel() throws RDFRDBException {
        return this.containsModel("DEFAULT");
    }

    static void copySpecializedGraphToModel(SpecializedGraph fromGraph, Model toModel, TripleMatch filter) throws RDFRDBException {
        Graph toGraph = toModel.getGraph();
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        ExtendedIterator it = fromGraph.find(filter, complete);
        while (it.hasNext()) {
            toGraph.add((Triple)it.next());
        }
        it.close();
    }

    public void setDatabaseType(String databaseType) {
        if (databaseType != null) {
            this.m_databaseType = databaseType.compareToIgnoreCase("mysql") == 0 ? "MySQL" : databaseType;
        }
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }

    public IRDBDriver getDriver() throws RDFRDBException {
        try {
            if (this.m_connection == null) {
                this.getConnection();
            }
            if (this.m_driver == null) {
                if (this.m_databaseType == null) {
                    throw new RDFRDBException("Error - attempt to call DBConnection.getDriver before setting the database type");
                }
                this.m_driver = (IRDBDriver)Class.forName("com.hp.hpl.jena.db.impl.Driver_" + this.m_databaseType).newInstance();
                this.m_driver.setConnection(this);
            }
        }
        catch (Exception e2) {
            throw new RDFRDBException("Failure to instantiate DB Driver:" + this.m_databaseType + " " + e2.toString(), e2);
        }
        return this.m_driver;
    }

    public void setDriver(IRDBDriver driver) {
        this.m_driver = driver;
    }

    public IRDBDriver getDriver(String layout, String database) throws RDFRDBException {
        this.setDatabaseType(database);
        return this.getDriver();
    }
}

