/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.AbsLexer;
import com.hp.hpl.jena.iri.impl.Expansion;
import com.hp.hpl.jena.iri.impl.VarPattern;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;

public class PatternCompiler
implements ViolationCodes {
    static VarPattern[] ipLiteral = new VarPattern[]{new VarPattern("\\[@{ipVFuture}\\]"), new VarPattern("\\[@{ipV6Address}\\]"), new VarPattern("\\[[^]*", 25)};
    static VarPattern[] ipVFuture = new VarPattern[]{new VarPattern("v@{lowerHexDig}+\\.[-a-zA-Z0-9._~!$&'()*+,;=:]*")};
    static VarPattern[] ipV6Address = new VarPattern[]{new VarPattern("((@{h16}:){6}@{ls32}|::(@{h16}:){5}@{ls32}|@{h16}?::(@{h16}:){4}@{ls32}|((@{h16}:){0,1}@{h16})?::(@{h16}:){3}@{ls32}|((@{h16}:){0,2}@{h16})?::(@{h16}:){2}@{ls32}|((@{h16}:){0,3}@{h16})?::(@{h16}:){1}@{ls32}|((@{h16}:){0,4}@{h16})?::@{ls32}|((@{h16}:){0,5}@{h16})?::@{h16}|((@{h16}:){0,6}@{h16})?::)")};
    static VarPattern[] h16 = new VarPattern[]{new VarPattern("@{lowerHexDig}{1,4}")};
    static VarPattern[] ls32 = new VarPattern[]{new VarPattern("(@{h16}:@{h16}|@{ipV4Address})")};
    static VarPattern[] ipV4Address = new VarPattern[]{new VarPattern("(@{decOctet}\\.){3}@{decOctet}"), new VarPattern("([0-9]+\\.){3}[0-9]+", 28), new VarPattern("[0-9\\.]+\\.[0-9\\.]+", 27)};
    static VarPattern[] decOctet = new VarPattern[]{new VarPattern("([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])")};
    static VarPattern[] regname = new VarPattern[]{new VarPattern("(@{label}\\.)*@{label}\\.?"), new VarPattern("[^]*", 29)};
    static VarPattern[] host = new VarPattern[]{new VarPattern("@{ipLiteral}"), new VarPattern("@{ipV4Address}"), new VarPattern("@{regname}")};
    static VarPattern[] lowerHexDig = new VarPattern[]{new VarPattern("[0-9a-f]"), new VarPattern("[0-9A-Fa-f]", 26)};
    static VarPattern[] label = new VarPattern[]{new VarPattern("@{labelPrefix}(@{labelInside}@{labelPostfix})?")};
    static VarPattern[] labelInside = new VarPattern[]{new VarPattern("@{labelSingleDashInside}?"), new VarPattern("(@{labelChar}|-)*", 20)};
    static VarPattern[] labelPrefix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 34), new VarPattern("@{labelChar}|@{acePrefix}", 32), new VarPattern("@{labelChar}|@{acePrefix}|-", new int[]{32, 34})};
    static VarPattern[] labelPostfix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 34)};
    static VarPattern[] labelSingleDashInside = new VarPattern[]{new VarPattern("(@{labelChar}+-)*@{labelChar}+")};
    static VarPattern[] acePrefix = new VarPattern[]{new VarPattern("@{letterDigit}{2}--")};
    static VarPattern[] letterDigit = new VarPattern[]{new VarPattern("[a-z0-9]"), new VarPattern("[a-zA-Z0-9]", 11)};
    static VarPattern[] labelChar = new VarPattern[]{new VarPattern("@{unreservedDNSLabel}")};
    static VarPattern[] unreservedDNSLabel = new VarPattern[]{new VarPattern("@{letterDigit}|_"), new VarPattern("@{letterDigit}|[_\\x80-\\uFFFF]", 22)};
    static long start;
    static String[] eCodeNames;
    static int count;
    static Writer out;

    public static void main(String[] args) throws IOException {
        start = System.currentTimeMillis();
        PatternCompiler.outRules("host");
        System.out.println(System.currentTimeMillis() - start);
    }

    private static void copy(String fname) throws IOException {
        int sz;
        FileReader in = new FileReader(fname);
        char[] buf = new char[2048];
        while ((sz = in.read(buf)) != -1) {
            out.write(buf, 0, sz);
        }
        ((Reader)in).close();
    }

    static VarPattern[] lookup(String name) {
        try {
            Field f = PatternCompiler.class.getDeclaredField(name);
            return (VarPattern[])f.get(null);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static String errorCodeName(int j) {
        if (eCodeNames == null) {
            eCodeNames = PatternCompiler.constantsFromClass(ViolationCodes.class, 200);
        }
        return eCodeNames[j];
    }

    static String[] constantsFromClass(Class cl, int cnt) {
        String[] names = new String[cnt];
        Field[] f = cl.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                names[f[i].getInt(null)] = f[i].getName();
                continue;
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
        }
        return names;
    }

    public static int errorCode(String s) throws NoSuchFieldException {
        try {
            Field f = ViolationCodes.class.getDeclaredField(s);
            return f.getInt(null);
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
            throw new RuntimeException(e3);
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
            throw new RuntimeException(e4);
        }
    }

    private static void outRules(String name) throws IOException {
        count = 0;
        out = new FileWriter("src/com/hp/hpl/jena/iri/impl/" + name + ".jflex");
        PatternCompiler.copy("src/com/hp/hpl/jena/iri/impl/iri.jflex");
        out.write("%class Lexer");
        out.write(name.substring(0, 1).toUpperCase());
        out.write(name.substring(1));
        out.write("\n%%\n");
        int[] exc1 = new int[]{20, 29};
        int[] empty = new int[]{};
        int[] sub1 = new int[]{32};
        int[] sub4 = new int[]{20};
        int[] sub3 = new int[]{29};
        new ExpandAndOutput(exc1, empty, true).expand("@{" + name + "}");
        new ExpandAndOutput(sub1, sub4, true).expand("@{" + name + "}");
        new ExpandAndOutput(empty, sub3, true).expand("@{" + name + "}");
        out.write("\n");
        System.out.println(name + ": " + count + " expansions");
        out.close();
        AbsLexer.runJFlex(new String[]{"src/com/hp/hpl/jena/iri/impl/" + name + ".jflex"});
        System.out.println(System.currentTimeMillis() - start);
    }

    private static final class ExpandAndOutput
    extends Expansion {
        int[] exc;
        int[] sub;
        boolean incExc;
        int ruleCount = 1;

        ExpandAndOutput(int[] exclude, int[] subset, boolean incExc) {
            this.exc = exclude;
            this.sub = subset;
            this.incExc = incExc;
        }

        void doIt(String regex, int eCount, int[] eCodes, int cCount, String[] c) {
            if (this.incExc == (!this.overlap(this.exc, eCount, eCodes) && this.subset(this.sub, eCount, eCodes))) {
                try {
                    out.write("/*\n");
                    for (int j = 0; j < cCount; ++j) {
                        out.write(c[j]);
                        out.write(10);
                    }
                    out.write("*/\n");
                    out.write(regex);
                    out.write(" {\n");
                    out.write("rule(" + ++count + "); ");
                    for (int i = 0; i < eCount; ++i) {
                        out.write("error(" + PatternCompiler.errorCodeName(eCodes[i]) + ");");
                    }
                    out.write("}\n");
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }

        private boolean subset(int[] ee, int el, int[] eCodes) {
            for (int i = 0; i < ee.length; ++i) {
                if (this.in(ee[i], el, eCodes)) continue;
                return false;
            }
            return true;
        }

        private boolean overlap(int[] ee, int el, int[] eCodes) {
            for (int i = 0; i < ee.length; ++i) {
                if (!this.in(ee[i], el, eCodes)) continue;
                return true;
            }
            return false;
        }

        private boolean in(int e0, int eCount, int[] eCodes) {
            for (int i = 0; i < eCount; ++i) {
                if (eCodes[i] != e0) continue;
                return true;
            }
            return false;
        }
    }
}

