/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.PatternCompiler;
import com.hp.hpl.jena.iri.test.TestCreator;
import com.hp.hpl.jena.iri.test.TestMEIri;
import com.hp.hpl.jena.iri.test.TestMERelativize;
import com.hp.hpl.jena.iri.test.TestMEResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestMoreExamples
extends TestCase
implements ViolationCodes {
    Map att;
    TestSuite parent;
    private Map methods = new HashMap();
    private long violations = 0L;
    private IRI iri;
    private String savedText = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$iri$IRI;

    static Map attr2map(Attributes a) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (int i = a.getLength() - 1; i >= 0; --i) {
            rslt.put(a.getQName(i), a.getValue(i));
        }
        return rslt;
    }

    public TestMoreExamples(String nm, Attributes att) {
        this(nm, att, null);
    }

    public void add(String text) {
        if (this.savedText != null) {
            text = this.savedText + text;
            this.savedText = null;
        }
        try {
            this.violations |= 1L << PatternCompiler.errorCode(text);
        }
        catch (NoSuchFieldException e2) {
            this.savedText = text;
        }
    }

    public TestMoreExamples(String nm, Attributes att, TestSuite suite) {
        super(TestMoreExamples.escape(nm));
        this.att = TestMoreExamples.attr2map(att);
        this.parent = suite;
    }

    private static String escape(String nm) {
        StringBuffer rslt = new StringBuffer();
        for (int i = 0; i < nm.length(); ++i) {
            char ch = nm.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                rslt.append(ch);
                continue;
            }
            rslt.append("\\u" + TestMoreExamples.pad4(Integer.toHexString(ch)));
        }
        return rslt.toString();
    }

    private static String pad4(String string) {
        switch (string.length()) {
            case 0: {
                return "0000";
            }
            case 1: {
                return "000" + string;
            }
            case 2: {
                return "00" + string;
            }
            case 3: {
                return "0" + string;
            }
        }
        return string;
    }

    public TestMoreExamples(String string) {
        super(TestMoreExamples.escape(string));
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private void add(String name, Attributes attrs) {
        if (name.equals("violation")) {
            return;
        }
        if (name.equals("violations")) {
            return;
        }
        this.methods.put(name, TestMoreExamples.attr2map(attrs));
    }

    private long getViolations() {
        long result = 0L;
        Iterator it = ((AbsIRIImpl)this.iri).allViolations();
        while (it.hasNext()) {
            result |= 1L << ((Violation)it.next()).getViolationCode();
        }
        return result;
    }

    public void runTest() {
        this.iri = this.getIRI();
        TestMoreExamples.assertEquals((String)"violations", (long)this.violations, (long)this.getViolations());
        Iterator it = this.methods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String m = (String)ent.getKey();
            Map attrs = (Map)ent.getValue();
            try {
                Object r = (class$com$hp$hpl$jena$iri$IRI == null ? TestMoreExamples.class$("com.hp.hpl.jena.iri.IRI") : class$com$hp$hpl$jena$iri$IRI).getDeclaredMethod(m, TestCreator.nullSign).invoke((Object)this.iri, new Object[0]);
                if (r == null) {
                    TestMoreExamples.assertEquals(attrs.get("nullValue"), (Object)"true");
                    continue;
                }
                TestMoreExamples.assertEquals(attrs.get("value"), (Object)r.toString());
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
            }
            catch (SecurityException e3) {
                e3.printStackTrace();
            }
            catch (IllegalAccessException e4) {
                e4.printStackTrace();
            }
            catch (InvocationTargetException e5) {
                Throwable t = e5;
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                String s = t.getMessage() != null ? t.getMessage() : t.toString();
                TestMoreExamples.assertEquals(attrs.get("exception"), (Object)s);
            }
            catch (NoSuchMethodException e6) {
                e6.printStackTrace();
            }
        }
    }

    final IRI getIRI() {
        if (this.iri == null) {
            this.iri = this.computeIRI();
        }
        return this.iri;
    }

    IRI computeIRI() {
        throw new UnsupportedOperationException();
    }

    static TestSuite suitex() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        TestSuite result = new TestSuite();
        result.setName("More IRI Tests");
        InputStream in = TestCreator.class.getClassLoader().getResourceAsStream("com/hp/hpl/jena/iri/test/test.xml");
        fact.newSAXParser().parse(in, (DefaultHandler)new TestReader(result));
        in.close();
        return result;
    }

    public static TestSuite suite() {
        try {
            return TestMoreExamples.suitex();
        }
        catch (SAXException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (ParserConfigurationException e4) {
            e4.printStackTrace();
        }
        TestSuite r2 = new TestSuite("exception-while-building-testsuite");
        return r2;
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
    }

    static class TestReader
    extends DefaultHandler {
        private Stack stack = new Stack();

        TestReader(TestSuite s) {
            this.stack.push(s);
        }

        private void push(Test t) {
            ((TestSuite)this.stack.peek()).addTest(t);
            this.stack.push(t);
        }

        public void startElement(String arg1, String arg2, String name, Attributes att) {
            if (name.equals("IRI")) {
                this.push((Test)new TestMEIri(att));
            } else if (name.equals("Result")) {
                this.push((Test)new TestMEResult(att, (TestSuite)this.stack.peek()));
            } else if (name.equals("Relativize")) {
                this.push((Test)new TestMERelativize(att, (TestSuite)this.stack.peek()));
            } else if (name.equals("Resolve")) {
                this.push((Test)new TestSuite());
            } else if (!name.equals("UriTests")) {
                this.add(name, att);
            }
        }

        private void add(String name, Attributes att) {
            ((TestMoreExamples)this.stack.peek()).add(name, att);
        }

        public void characters(char[] ch, int st, int lg) {
            String text = new String(ch, st, lg).trim();
            if (text.length() > 0) {
                ((TestMoreExamples)this.stack.peek()).add(text);
            }
        }

        public void endElement(String arg1, String arg2, String name) {
            if (name.equals("Resolve")) {
                TestSuite t = (TestSuite)this.stack.pop();
                t.setName(((TestCase)t.testAt(0)).getName() + "  " + ((TestCase)t.testAt(1)).getName());
            } else if (name.equals("IRI") || name.equals("Result") || name.equals("Relativize")) {
                this.stack.pop();
            }
        }
    }
}

