/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.AntlrUtils;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class N3toRDF
implements N3ParserEventHandler {
    protected static Log log = LogFactory.getLog(N3toRDF.class);
    Model model;
    Map resourceRef = new HashMap();
    Map propertyRef = new HashMap();
    Map myPrefixMapping = new HashMap();
    boolean allowPropertySymbols = true;
    boolean allowKeywordA = true;
    static final String NS_rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String NS_rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    static final String LOG_IMPLIES = "http://www.w3.org/2000/10/swap/log#implies";
    static final String LOG_MEANS = "http://www.w3.org/2000/10/swap/log#means";
    static final String XMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private IRIResolver resolver = null;
    final String anonPrefix = "_";
    private Map bNodeMap = new HashMap();

    public N3toRDF(Model model, String base) {
        this.resolver = new IRIResolver(base);
        this.model = model;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void error(Exception ex, String message) {
        throw new N3Exception(message);
    }

    public void error(String message) {
        this.error(null, message);
    }

    public void warning(Exception ex, String message) {
        log.warn(message, ex);
    }

    public void warning(String message) {
        log.warn(message);
    }

    public void deprecated(Exception ex, String message) {
        throw new N3Exception(message);
    }

    public void deprecated(String message) {
        this.deprecated(null, message);
    }

    public void startFormula(int line, String context) {
        this.error("Line " + line + ": N3toRDF: All statements are asserted - no formulae in RDF");
    }

    public void endFormula(int line, String context) {
    }

    public void directive(int line, AST directive, AST[] args, String context) {
        if (directive.getType() == 19) {
            if (args[0].getType() != 6) {
                this.error("Line " + line + ": N3toRDF: Prefix directive does not start with a prefix! " + args[0].getText() + "[" + N3Parser.getTokenNames()[args[0].getType()] + "]");
                return;
            }
            String prefix = args[0].getText();
            if (prefix.endsWith(":")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if (args[1].getType() != 40) {
                this.error("Line " + line + ": N3toRDF: Prefix directive does not supply a URIref! " + args[1].getText());
                return;
            }
            String uriref = args[1].getText();
            if ((uriref = this.expandURIRef(uriref, line)) == null) {
                this.error("Line " + line + ": N3toRDF: Relative URI can't be resolved in in @prefix directive");
            }
            this.setPrefixMapping(this.model, prefix, uriref);
            return;
        }
        this.warning("Line " + line + ": N3toRDF: Directive not recongized and ignored: " + directive.getText());
    }

    public void quad(int line, AST subj, AST prop, AST obj, String context) {
        if (context != null) {
            this.error("Line " + line + ": N3toRDF: All statement are asserted - no formulae");
        }
        try {
            int pType = prop.getType();
            String propStr = prop.getText();
            Property pNode = null;
            switch (pType) {
                case 28: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + line + ": N3toRDF: Property symbol '=>' not allowed");
                    }
                    propStr = LOG_IMPLIES;
                    break;
                }
                case 57: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + line + ": N3toRDF: Property symbol '<=>' not allowed");
                    }
                    propStr = LOG_MEANS;
                    break;
                }
                case 29: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + line + ": N3toRDF: Property symbol '<=' not allowed");
                    }
                    propStr = LOG_IMPLIES;
                    AST tmp = obj;
                    obj = subj;
                    subj = tmp;
                    break;
                }
                case 27: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + line + ": N3toRDF: Property symbol '=' not allowed");
                    }
                    pNode = OWL.sameAs;
                    break;
                }
                case 13: {
                    if (!this.allowKeywordA) {
                        this.error("Line " + line + ": N3toRDF: Property symbol 'a' not allowed");
                    }
                    pNode = RDF.type;
                    break;
                }
                case 6: {
                    String uriref;
                    if (prop.getText().startsWith("_:")) {
                        this.error("Line " + line + ": N3toRDF: Can't have properties with labelled bNodes in RDF");
                    }
                    if ((uriref = this.expandPrefix(this.model, propStr)) == propStr) {
                        this.error("Line " + line + ": N3toRDF: Undefined qname namespace: " + propStr);
                        return;
                    }
                    pNode = this.model.createProperty(uriref);
                    break;
                }
                case 40: {
                    propStr = this.expandURIRef(propStr, line);
                    break;
                }
                case 16: {
                    pNode = RDF.first;
                    break;
                }
                case 17: {
                    pNode = RDF.rest;
                    break;
                }
                case 4: {
                    this.error("Line " + line + ": N3toRDF: Can't have anon. properties in RDF");
                    break;
                }
                default: {
                    this.error("Line " + line + ": N3toRDF: Shouldn't see " + N3EventPrinter.formatSlot(prop) + " at this point!");
                }
            }
            if (pNode == null) {
                pNode = this.model.createProperty(propStr);
            } else {
                propStr = pNode.getURI();
            }
            RDFNode sNode = this.createNode(line, subj);
            if (sNode instanceof Literal) {
                this.error("Line " + line + ": N3toRDF: Subject can't be a literal: " + subj.getText());
            }
            RDFNode oNode = this.createNode(line, obj);
            Statement stmt = this.model.createStatement((Resource)sNode, pNode, oNode);
            this.model.add(stmt);
        }
        catch (JenaException rdfEx) {
            this.error("Line " + line + ": JenaException: " + rdfEx);
        }
    }

    private RDFNode createNode(int line, AST thing) {
        String text = thing.getText();
        switch (thing.getType()) {
            case 38: {
                Resource xsdType = XSD.integer;
                if (text.indexOf(46) >= 0) {
                    xsdType = XSD.decimal;
                }
                if (text.indexOf(101) >= 0 || text.indexOf(69) >= 0) {
                    xsdType = XSD.xdouble;
                }
                return this.model.createTypedLiteral(text, xsdType.getURI());
            }
            case 22: {
                String langTag;
                AST a1 = thing.getNextSibling();
                AST a2 = a1 == null ? null : a1.getNextSibling();
                AST datatype = null;
                AST lang = null;
                if (a2 != null) {
                    if (a2.getType() == 39) {
                        datatype = a2.getFirstChild();
                    } else {
                        lang = a2;
                    }
                }
                if (a1 != null) {
                    if (a1.getType() == 39) {
                        datatype = a1.getFirstChild();
                    } else {
                        lang = a1;
                    }
                }
                String string = langTag = lang != null ? lang.getText().substring(1) : null;
                if (datatype == null) {
                    return this.model.createLiteral(text, langTag);
                }
                String typeURI = datatype.getText();
                if (datatype.getType() != 6 && datatype.getType() != 40) {
                    this.error("Line " + line + ": N3toRDF: Must use URIref or QName datatype URI: " + text + "^^" + typeURI + "(" + N3Parser.getTokenNames()[datatype.getType()] + ")");
                    return this.model.createLiteral("Illegal literal: " + text + "^^" + typeURI);
                }
                if (datatype.getType() == 6) {
                    if (typeURI.startsWith("_:") || typeURI.startsWith("=:")) {
                        this.error("Line " + line + ": N3toRDF: Can't use bNode for datatype URI: " + text + "^^" + typeURI);
                        return this.model.createLiteral("Illegal literal: " + text + "^^" + typeURI);
                    }
                    String typeURI2 = this.expandPrefix(this.model, typeURI);
                    if (typeURI2 == typeURI) {
                        this.error("Line " + line + ": N3toRDF: Undefined qname namespace in datatype: " + typeURI);
                    }
                    typeURI = typeURI2;
                }
                typeURI = this.expandURIRef(typeURI, line);
                return this.model.createTypedLiteral(text, typeURI);
            }
            case 6: {
                if (text.startsWith("_:") && this.model.getNsPrefixURI("_") == null) {
                    if (!this.bNodeMap.containsKey(text)) {
                        this.bNodeMap.put(text, this.model.createResource());
                    }
                    return (Resource)this.bNodeMap.get(text);
                }
                String uriref = this.expandPrefix(this.model, text);
                if (uriref == text) {
                    this.error("Line " + line + ": N3toRDF: Undefined qname namespace: " + text);
                    return null;
                }
                return this.model.createResource(this.expandURIRef(uriref, line));
            }
            case 40: {
                return this.model.createResource(this.expandURIRef(text, line));
            }
            case 18: {
                return RDF.nil;
            }
            case 15: {
                return RDF.List;
            }
            case 4: {
                if (!this.bNodeMap.containsKey(text)) {
                    this.bNodeMap.put(text, this.model.createResource());
                }
                return (Resource)this.bNodeMap.get(text);
            }
            case 41: {
                this.error("Line " + line + ": N3toRDF: Can't map variables to RDF: " + text);
                break;
            }
            default: {
                this.error("Line " + line + ": N3toRDF: Can't map to a resource or literal: " + AntlrUtils.ast(thing));
            }
        }
        return null;
    }

    private String expandURIRef(String text, int line) {
        try {
            return this.resolver.resolve(text);
        }
        catch (Exception ex) {
            this.error("Line " + line + ": N3toRDF: Bad URI: " + text + " (" + ex.getMessage() + ")");
            return null;
        }
    }

    private boolean hasURIscheme(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ':') {
                return true;
            }
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '+' || ch == '-' | ch == '.') continue;
            return false;
        }
        return false;
    }

    private void setPrefixMapping(Model m, String prefix, String uriref) {
        try {
            this.model.setNsPrefix(prefix, uriref);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            this.warning("Prefix mapping '" + prefix + "' illegal: used but not recorded in model");
        }
        this.myPrefixMapping.put(prefix, uriref);
    }

    private String expandPrefix(Model m, String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = (String)this.myPrefixMapping.get(prefix);
        if (uri == null) {
            return prefixed;
        }
        return uri + prefixed.substring(colon + 1);
    }
}

