/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyImpl
extends ResourceImpl
implements Property {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return n.isURI();
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            return new PropertyImpl(n, eg);
        }
    };
    protected static Log logger = LogFactory.getLog(PropertyImpl.class);
    protected int ordinal = -1;

    public PropertyImpl(String uri) {
        super(uri);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public RDFNode inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    private void checkLocalName() {
        String localName = this.getLocalName();
        if (localName == null || localName.equals("")) {
            throw new InvalidPropertyURIException(this.getURI());
        }
    }

    public PropertyImpl(String nameSpace, String localName) {
        super(nameSpace, localName);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public PropertyImpl(String uri, ModelCom m) {
        super(uri, m);
        this.checkOrdinal();
    }

    public PropertyImpl(String nameSpace, String localName, ModelCom m) {
        super(nameSpace, localName, m);
        this.checkOrdinal();
    }

    public PropertyImpl(Node n, EnhGraph m) {
        super(n, m);
        this.checkOrdinal();
    }

    public PropertyImpl(String nameSpace, String localName, int ordinal, ModelCom m) {
        super(nameSpace, localName, m);
        this.checkLocalName();
        this.ordinal = ordinal;
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        if (this.ordinal < 0) {
            this.ordinal = this.computeOrdinal();
        }
        return this.ordinal;
    }

    private int computeOrdinal() {
        String localName = this.getLocalName();
        if (this.getNameSpace().equals(RDF.getURI()) && localName.matches("_[0-9]+")) {
            return this.parseInt(localName.substring(1));
        }
        return 0;
    }

    private int parseInt(String digits) {
        try {
            return Integer.parseInt(digits);
        }
        catch (NumberFormatException e2) {
            throw new JenaException("checkOrdinal fails on " + digits, e2);
        }
    }

    protected void checkOrdinal() {
    }
}

