/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.ResourceReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testNTripleReader {
    protected static Log logger = LogFactory.getLog(testNTripleReader.class);
    private boolean inError = false;

    protected static void doTest(Model m1) {
        new testNTripleReader().test(m1);
    }

    void test(Model m1) {
        String test = "testNTripleReader";
        String filebase = "testing/regression/" + test + "/";
        int n = 0;
        try {
            this.empty(m1);
            ++n;
            m1.read(ResourceReader.getInputStream(filebase + "1.nt"), "", "N-TRIPLE");
            if (m1.size() != 5L) {
                this.error(test, n);
            }
            StmtIterator iter = m1.listStatements(null, null, "foo\"\\\n\r\tbar");
            ++n;
            if (!iter.hasNext()) {
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            this.inError = true;
            logger.error(" test " + test + "[" + n + "]", e2);
        }
    }

    protected void empty(Model m) {
        StmtIterator iter = m.listStatements();
        while (iter.hasNext()) {
            iter.nextStatement();
            iter.remove();
        }
    }

    protected void error(String test, int n) {
        System.out.println(test + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

