/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.CharacterSetFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class CDATAFilter
extends ProxyReceiver {
    private FastStringBuffer buffer = new FastStringBuffer(256);
    private Stack stack = new Stack();
    private int[] nameList;
    private CharacterSet characterSet;

    public void setOutputProperties(Properties properties) throws XPathException {
        this.nameList = this.getCdataElements(properties);
        this.characterSet = CharacterSetFactory.getCharacterSet(properties, this.getPipelineConfiguration().getController());
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        this.flush(this.buffer);
        this.stack.push(new Integer(n & 0xFFFFF));
        super.startElement(n, n2, n4, n5);
    }

    public void endElement() throws XPathException {
        this.flush(this.buffer);
        this.stack.pop();
        super.endElement();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        this.flush(this.buffer);
        super.processingInstruction(string, charSequence, n, n2);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if ((n2 & 1) == 0) {
            this.buffer.append(((Object)charSequence).toString());
        } else {
            this.flush(this.buffer);
            super.characters(charSequence, n, n2);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        this.flush(this.buffer);
        super.comment(charSequence, n, n2);
    }

    public void flush(FastStringBuffer fastStringBuffer) throws XPathException {
        int n;
        boolean bl;
        int n2 = fastStringBuffer.length();
        if (n2 == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            bl = false;
        } else {
            n = (Integer)this.stack.peek();
            bl = this.isCDATA(n);
        }
        if (bl) {
            n = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = fastStringBuffer.charAt(n4);
                int n6 = 1;
                if (XMLChar.isHighSurrogate((char)n5)) {
                    n5 = XMLChar.supplemental((char)n5, fastStringBuffer.charAt(n4 + 1));
                    n6 = 2;
                }
                if (this.characterSet.inCharset(n5)) {
                    ++n4;
                    continue;
                }
                char[] cArray = new char[n4 - n];
                fastStringBuffer.getChars(n, n4, cArray, 0);
                this.flushCDATA(cArray, n4 - n);
                while (n4 < n2) {
                    super.characters(fastStringBuffer.subSequence(n4, n4 + n6), 0, 0);
                    if ((n4 += n6) >= n2) break;
                    n5 = fastStringBuffer.charAt(n4);
                    n6 = 1;
                    if (XMLChar.isHighSurrogate((char)n5)) {
                        n5 = XMLChar.supplemental((char)n5, fastStringBuffer.charAt(n4 + 1));
                        n6 = 2;
                    }
                    if (!this.characterSet.inCharset(n5)) continue;
                }
                n = n4;
            }
            char[] cArray = new char[n2 - n];
            fastStringBuffer.getChars(n, n2, cArray, 0);
            this.flushCDATA(cArray, n2 - n);
        } else {
            super.characters(fastStringBuffer, 0, 0);
        }
        fastStringBuffer.setLength(0);
    }

    private void flushCDATA(char[] cArray, int n) throws XPathException {
        if (n == 0) {
            return;
        }
        super.characters("<![CDATA[", 0, 1);
        int n2 = 0;
        for (int i = 0; i < n - 2; ++i) {
            if (cArray[i] != ']' || cArray[i + 1] != ']' || cArray[i + 2] != '>') continue;
            super.characters(new CharSlice(cArray, n2, i + 2 - n2), 0, 1);
            super.characters("]]><![CDATA[", 0, 1);
            n2 = i + 2;
        }
        super.characters(new CharSlice(cArray, n2, n - n2), 0, 1);
        super.characters("]]>", 0, 1);
    }

    private boolean isCDATA(int n) {
        for (int i = 0; i < this.nameList.length; ++i) {
            if (this.nameList[i] != n) continue;
            return true;
        }
        return false;
    }

    private int[] getCdataElements(Properties properties) {
        String string = properties.getProperty("cdata-section-elements");
        if (string == null) {
            return new int[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string);
        while (stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer2.nextToken();
            nArray[n++] = this.getNamePool().getFingerprintForExpandedName(string2);
        }
        return nArray;
    }
}

