/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class DocumentValidator
extends ProxyReceiver {
    boolean foundElement = false;
    int level = 0;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        if (this.foundElement && this.level == 0) {
            DynamicError dynamicError = new DynamicError("A valid document must have only one child element");
            throw dynamicError;
        }
        this.foundElement = true;
        ++this.level;
        super.startElement(n, n2, n4, n5);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.level == 0) {
            if (Whitespace.isWhite(charSequence)) {
                return;
            }
            DynamicError dynamicError = new DynamicError("A valid document must contain no text outside the outermost element");
            throw dynamicError;
        }
        super.characters(charSequence, n, n2);
    }

    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            if (!this.foundElement) {
                DynamicError dynamicError = new DynamicError("A valid document must have a child element");
                throw dynamicError;
            }
            this.foundElement = false;
            super.endDocument();
            this.level = -1;
        }
    }
}

