/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private int nonASCIIRepresentation = 0;
    private int excludedRepresentation = 2;
    private int inScript;
    private boolean started = false;
    private String elementName;
    private short uriCode;
    static HTMLTagHashSet emptyTags = new HTMLTagHashSet(31);
    private static HTMLTagHashSet booleanAttributes;
    private static HTMLTagHashSet booleanCombinations;
    private static final String[] latin1Entities;

    private static int representationCode(String string) {
        if (string.equalsIgnoreCase("native")) {
            return 0;
        }
        if (string.equalsIgnoreCase("entity")) {
            return 1;
        }
        if (string.equalsIgnoreCase("decimal")) {
            return 2;
        }
        if (string.equalsIgnoreCase("hex")) {
            return 3;
        }
        return 1;
    }

    private static void setEmptyTag(String string) {
        emptyTags.add(string);
    }

    protected static boolean isEmptyTag(String string) {
        return emptyTags.contains(string);
    }

    private static void setBooleanAttribute(String string, String string2) {
        booleanAttributes.add(string2);
        booleanCombinations.add(string + '+' + string2);
    }

    private static boolean isBooleanAttribute(String string, String string2, String string3) {
        if (!string2.equalsIgnoreCase(string3)) {
            return false;
        }
        if (!booleanAttributes.contains(string2)) {
            return false;
        }
        return booleanCombinations.contains(string + '+' + string2);
    }

    public void open() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        String string = this.outputProperties.getProperty("byte-order-mark");
        if ("yes".equals(string) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string2 = this.outputProperties.getProperty("doctype-system");
        String string3 = this.outputProperties.getProperty("doctype-public");
        if (string2 != null || string3 != null) {
            this.writeDocType("html", string2, string3);
        }
        this.empty = false;
        this.inScript = -1000000;
        String string4 = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation");
        if (string4 != null) {
            String string5;
            String string6;
            int n = string4.indexOf(59);
            if (n < 0) {
                string6 = string4;
                string5 = string4;
            } else {
                string6 = string4.substring(0, n).trim();
                string5 = string4.substring(n + 1).trim();
            }
            this.nonASCIIRepresentation = HTMLEmitter.representationCode(string6);
            this.excludedRepresentation = HTMLEmitter.representationCode(string5);
            if (this.excludedRepresentation == 0) {
                this.excludedRepresentation = 1;
            }
        }
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        super.startElement(n, n2, n4, n5);
        this.uriCode = this.namePool.getURICode(n);
        this.elementName = (String)this.elementStack.peek();
        if (this.uriCode == 0 && (this.elementName.equalsIgnoreCase("script") || this.elementName.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
    }

    public void startContent() throws XPathException {
        this.closeStartTag();
    }

    protected void writeAttribute(int n, String string, CharSequence charSequence, int n2) throws XPathException {
        try {
            if (this.uriCode == 0 && HTMLEmitter.isBooleanAttribute(this.elementName, string, ((Object)charSequence).toString())) {
                this.writer.write(string);
                return;
            }
            super.writeAttribute(n, string, charSequence, n2);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl) throws IOException, XPathException {
        boolean[] blArray;
        int n = 0;
        boolean[] blArray2 = blArray = bl ? specialInAtt : specialInText;
        if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).writeEscape(blArray, this.writer);
            return;
        }
        boolean bl2 = false;
        while (n < charSequence.length()) {
            char c;
            int n2;
            for (n2 = n; n2 < charSequence.length() && (charSequence.charAt(n2) < '\u007f' ? !blArray[charSequence.charAt(n2)] : this.characterSet.inCharset(charSequence.charAt(n2)) && this.nonASCIIRepresentation == 0 && charSequence.charAt(n2) > '\u00a0'); ++n2) {
            }
            if (n2 == charSequence.length()) {
                if (n == 0) {
                    this.writeCharSequence(charSequence);
                } else {
                    this.writeCharSequence(charSequence.subSequence(n, n2));
                }
                return;
            }
            if (n2 > n) {
                this.writeCharSequence(charSequence.subSequence(n, n2));
            }
            if ((c = charSequence.charAt(n2)) == '\u0000') {
                bl2 = !bl2;
            } else if (bl2) {
                this.writer.write(c);
            } else if (c <= '\u007f') {
                if (bl) {
                    if (c == '<') {
                        this.writer.write(60);
                    } else if (c == '>') {
                        this.writer.write("&gt;");
                    } else if (c == '&') {
                        if (n2 + 1 < charSequence.length() && charSequence.charAt(n2 + 1) == '{') {
                            this.writer.write(38);
                        } else {
                            this.writer.write("&amp;");
                        }
                    } else if (c == '\"') {
                        this.writer.write("&#34;");
                    } else if (c == '\n') {
                        this.writer.write("&#xA;");
                    }
                } else if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else if (c == '&') {
                    this.writer.write("&amp;");
                }
            } else if (c == '\u00a0') {
                this.writer.write("&nbsp;");
            } else {
                if (c >= '\u007f' && c < '\u00a0') {
                    DynamicError dynamicError = new DynamicError("Illegal HTML character: decimal " + c);
                    dynamicError.setErrorCode("SERE0014");
                    throw dynamicError;
                }
                if (c >= '\ud800' && c <= '\udbff') {
                    int n4 = (c - 55296) * 1024 + (charSequence.charAt(n2 + 1) - 56320) + 65536;
                    this.outputCharacterReference(n4);
                    ++n2;
                } else if (this.characterSet.inCharset(c)) {
                    switch (this.nonASCIIRepresentation) {
                        case 0: {
                            this.writer.write(c);
                            break;
                        }
                        case 1: {
                            if (c > '\u00a0' && c <= '\u00ff') {
                                this.writer.write(38);
                                this.writer.write(latin1Entities[c - 160]);
                                this.writer.write(59);
                                break;
                            }
                        }
                        case 2: {
                            this.preferHex = false;
                            this.outputCharacterReference(c);
                            break;
                        }
                        case 3: {
                            this.preferHex = true;
                        }
                        default: {
                            this.outputCharacterReference(c);
                            break;
                        }
                    }
                } else {
                    this.preferHex = this.excludedRepresentation == 3;
                    this.outputCharacterReference(c);
                }
            }
            n = ++n2;
        }
    }

    public void endElement() throws XPathException {
        String string = (String)this.elementStack.peek();
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(string) && this.uriCode == 0) {
            this.elementStack.pop();
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        int n4 = n2;
        if (this.inScript > 0) {
            n4 |= 1;
        }
        super.characters(charSequence, n, n4);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.empty) {
            this.openDocument();
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '>') continue;
            DynamicError dynamicError = new DynamicError("A processing instruction in HTML must not contain a > character");
            dynamicError.setErrorCode("SERE0015");
            throw dynamicError;
        }
        try {
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(32);
            this.writeCharSequence(charSequence);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HTMLTagHashSet(31);
        booleanCombinations = new HTMLTagHashSet(53);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

