/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[128];
    private static final char[] lookUpHexAlphabet = new char[16];

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n4 < n) {
            int n5 = byArray[n4];
            if (n5 < 0) {
                n5 += 256;
            }
            cArray[n4 * 2] = lookUpHexAlphabet[n5 >> 4];
            cArray[n4 * 2 + 1] = lookUpHexAlphabet[n5 & 0xF];
            ++n4;
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            char c = cArray[n4 * 2];
            int n7 = n6 = c < '\u0080' ? hexNumberTable[c] : -1;
            if (n6 == -1) {
                return null;
            }
            c = cArray[n4 * 2 + 1];
            int n8 = n5 = c < '\u0080' ? hexNumberTable[c] : -1;
            if (n5 == -1) {
                return null;
            }
            byArray[n4] = (byte)(n6 << 4 | n5);
            ++n4;
        }
        return byArray;
    }

    static {
        int n = 0;
        while (n < 128) {
            HexBin.hexNumberTable[n] = -1;
            ++n;
        }
        int n2 = 57;
        while (n2 >= 48) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 48);
            --n2;
        }
        int n4 = 70;
        while (n4 >= 65) {
            HexBin.hexNumberTable[n4] = (byte)(n4 - 65 + 10);
            --n4;
        }
        int n5 = 102;
        while (n5 >= 97) {
            HexBin.hexNumberTable[n5] = (byte)(n5 - 97 + 10);
            --n5;
        }
        int n6 = 0;
        while (n6 < 10) {
            HexBin.lookUpHexAlphabet[n6] = (char)(48 + n6);
            ++n6;
        }
        int n7 = 10;
        while (n7 <= 15) {
            HexBin.lookUpHexAlphabet[n7] = (char)(65 + n7 - 10);
            ++n7;
        }
    }
}

