/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.biopax.paxtools.impl.level3.EvidenceImpl;
import org.biopax.paxtools.impl.level3.InteractionImpl;
import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.impl.level3.ProvenanceImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.DataSourceFieldBridge;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.biopax.paxtools.util.SetStringBridge;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Store;

@Entity
@Proxy(proxyClass=org.biopax.paxtools.model.level3.Entity.class)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public abstract class EntityImpl
extends NamedImpl
implements org.biopax.paxtools.model.level3.Entity {
    private Set<Interaction> participantOf;
    private Set<String> availability = BPCollections.I.createSet();
    private Set<Provenance> dataSource = BPCollections.I.createSafeSet();
    private Set<Evidence> evidence;

    public EntityImpl() {
        this.participantOf = BPCollections.I.createSafeSet();
        this.evidence = BPCollections.I.createSafeSet();
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="availability")
    @Field(name="availability", analyze=Analyze.YES)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getAvailability() {
        return this.availability;
    }

    public void setAvailability(Set<String> availability) {
        this.availability = availability;
    }

    @Override
    public void addAvailability(String availability_text) {
        if (availability_text != null && availability_text.length() > 0) {
            this.availability.add(availability_text);
        }
    }

    @Override
    public void removeAvailability(String availability_text) {
        if (availability_text != null) {
            this.availability.remove(availability_text);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ProvenanceImpl.class)
    @JoinTable(name="dataSource")
    @Field(name="dataSource", store=Store.YES, analyze=Analyze.NO)
    @FieldBridge(impl=DataSourceFieldBridge.class)
    public Set<Provenance> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Set<Provenance> dataSource2) {
        this.dataSource = dataSource2;
    }

    @Override
    public void addDataSource(Provenance dataSource2) {
        if (dataSource2 != null) {
            this.dataSource.add(dataSource2);
        }
    }

    @Override
    public void removeDataSource(Provenance dataSource2) {
        if (dataSource2 != null) {
            this.dataSource.remove(dataSource2);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=InteractionImpl.class, mappedBy="participant")
    public Set<Interaction> getParticipantOf() {
        return this.participantOf;
    }

    protected void setParticipantOf(Set<Interaction> participantOf) {
        this.participantOf = participantOf;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EvidenceImpl.class)
    @JoinTable(name="evidence")
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence newEvidence) {
        if (newEvidence != null) {
            this.evidence.add(newEvidence);
        }
    }

    @Override
    public void removeEvidence(Evidence oldEvidence) {
        if (oldEvidence != null) {
            this.evidence.remove(oldEvidence);
        }
    }

    protected void setEvidence(Set<Evidence> newEvidence) {
        this.evidence = newEvidence;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        boolean equivalance = false;
        if (element instanceof org.biopax.paxtools.model.level3.Entity) {
            org.biopax.paxtools.model.level3.Entity otherEntity = (org.biopax.paxtools.model.level3.Entity)element;
            equivalance = SetEquivalenceChecker.hasEquivalentIntersection(this.dataSource, otherEntity.getDataSource()) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(otherEntity.getXref(), UnificationXref.class)) && SetEquivalenceChecker.hasEquivalentIntersection(this.evidence, otherEntity.getEvidence());
        }
        return equivalance;
    }
}

