/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.SequenceLocationImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PositionStatusType;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=SequenceSite.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SequenceSiteImpl
extends SequenceLocationImpl
implements SequenceSite {
    private PositionStatusType positionStatus;
    private int sequencePosition = UNKNOWN_INT;

    @Transient
    public Class<? extends SequenceSite> getModelInterface() {
        return SequenceSite.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof SequenceSite)) {
            return false;
        }
        SequenceSite that = (SequenceSite)element;
        return this.sequencePosition == that.getSequencePosition() && this.positionStatus != null ? this.positionStatus.equals((Object)that.getPositionStatus()) : that.getPositionStatus() == null;
    }

    @Override
    public int equivalenceCode() {
        int result = 29 + this.sequencePosition;
        result = 29 * result + (this.positionStatus != null ? this.positionStatus.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSequencePosition());
    }

    @Override
    @Enumerated
    public PositionStatusType getPositionStatus() {
        return this.positionStatus;
    }

    @Override
    public void setPositionStatus(PositionStatusType positionStatus) {
        this.positionStatus = positionStatus;
    }

    @Override
    public int getSequencePosition() {
        return this.sequencePosition;
    }

    @Override
    public void setSequencePosition(int sequencePosition) {
        this.sequencePosition = sequencePosition;
    }
}

