/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.avsdf;

import java.util.Set;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.avsdf.AVSDFCircle;
import org.ivis.layout.avsdf.AVSDFEdge;
import org.ivis.layout.avsdf.AVSDFNode;
import org.ivis.layout.avsdf.AVSDFNodesEdgeCrossingSort;

public class AVSDFLayout
extends Layout {
    private int nodeSeparation = 60;

    @Override
    public LGraph newGraph(Object vObject) {
        return new AVSDFCircle(null, this.graphManager, vObject);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new AVSDFNode(this.graphManager, vNode);
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new AVSDFEdge(null, null, vEdge);
    }

    @Override
    public void initParameters() {
        super.initParameters();
        if (!this.isSubLayout) {
            LayoutOptionsPack.AVSDF layoutOptionsPack = LayoutOptionsPack.getInstance().getAVSDF();
            this.nodeSeparation = layoutOptionsPack.nodeSeparation;
        }
    }

    public int getNodeSeparation() {
        return this.nodeSeparation;
    }

    public void setNodeSeparation(int nodeSeparation) {
        this.nodeSeparation = nodeSeparation;
    }

    @Override
    public boolean layout() {
        if (this.graphManager.getGraphs().size() > 1) {
            return false;
        }
        AVSDFCircle clusterGraph = (AVSDFCircle)this.graphManager.getRoot();
        clusterGraph.setNodeSeperation(this.nodeSeparation);
        clusterGraph.calculateRadius();
        clusterGraph.initOrdering();
        while (!clusterGraph.hasFinishedOrdering()) {
            AVSDFNode node = clusterGraph.findNodeToPlace();
            clusterGraph.putInOrder(node);
        }
        this.postProcess(clusterGraph);
        clusterGraph.correctAngles();
        for (AVSDFNode node : clusterGraph.getNodes()) {
            node.setCenter(clusterGraph.getCenterX() + clusterGraph.getRadius() * Math.cos(node.getAngle()), clusterGraph.getCenterY() + clusterGraph.getRadius() * Math.sin(node.getAngle()));
        }
        return true;
    }

    public void postProcess(AVSDFCircle circle) {
        circle.calculateEdgeCrossingsOfNodes();
        Object[] array = circle.getNodes().toArray();
        AVSDFNodesEdgeCrossingSort sort = new AVSDFNodesEdgeCrossingSort(array);
        sort.quicksort();
        for (int i = array.length - 1; i >= 0; --i) {
            AVSDFNode node = (AVSDFNode)array[i];
            int currentCrossingNumber = node.getTotalCrossingOfEdges();
            Set neighbors = node.getNeighborsList();
            for (AVSDFNode tempNode : neighbors) {
                int newIndex = (tempNode.getIndex() + 1) % circle.getSize();
                int oldIndex = node.getIndex();
                if (oldIndex == newIndex) continue;
                node.setIndex(newIndex);
                if (oldIndex < node.getIndex()) {
                    oldIndex += circle.getSize();
                }
                for (int k = node.getIndex(); k < oldIndex; ++k) {
                    AVSDFNode temp = circle.getOrder()[k % circle.getSize()];
                    temp.setIndex((temp.getIndex() + 1) % circle.getSize());
                }
                node.calculateTotalCrossing();
                int newCrossingNumber = node.getTotalCrossingOfEdges();
                if (newCrossingNumber >= currentCrossingNumber) {
                    circle.loadOldIndicesOfNodes();
                    continue;
                }
                circle.reOrderVertices();
                currentCrossingNumber = newCrossingNumber;
            }
        }
    }
}

