/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cose;

import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.cose.CoarseningEdge;
import org.ivis.layout.cose.CoarseningNode;

public class CoarseningGraph
extends LGraph {
    private Layout layout;

    protected CoarseningGraph(LNode parent, Layout layout, Object vGraph) {
        super(parent, layout, vGraph);
    }

    public CoarseningGraph(Layout _layout) {
        this(null, _layout, null);
        this.layout = _layout;
    }

    public void coarsen() {
        this.unmatchAll();
        if (this.getNodes().size() > 0) {
            while (!((CoarseningNode)this.getNodes().get(0)).isMatched()) {
                CoarseningNode v = (CoarseningNode)this.getNodes().get(0);
                CoarseningNode u = v.getMatching();
                this.contract(v, u);
            }
            for (Object obj : this.getNodes()) {
                CoarseningNode y = (CoarseningNode)obj;
                CoSENode z = (CoSENode)this.layout.newNode(null);
                z.setPred1(y.getNode1().getReference());
                y.getNode1().getReference().setNext(z);
                if (y.getNode2() != null) {
                    z.setPred2(y.getNode2().getReference());
                    y.getNode2().getReference().setNext(z);
                }
                y.setReference(z);
            }
        }
    }

    private void unmatchAll() {
        for (Object obj : this.getNodes()) {
            CoarseningNode v = (CoarseningNode)obj;
            v.setMatched(false);
        }
    }

    private void contract(CoarseningNode v, CoarseningNode u) {
        CoarseningNode x;
        CoarseningNode t = new CoarseningNode();
        this.add(t);
        t.setNode1(v);
        for (Object obj : v.getNeighborsList()) {
            x = (CoarseningNode)obj;
            if (x == t) continue;
            this.add(new CoarseningEdge(), t, x);
        }
        t.setWeight(v.getWeight());
        this.remove(v);
        if (u != null) {
            t.setNode2(u);
            for (Object obj : u.getNeighborsList()) {
                x = (CoarseningNode)obj;
                if (x == t) continue;
                this.add(new CoarseningEdge(), t, x);
            }
            t.setWeight(t.getWeight() + u.getWeight());
            this.remove(u);
        }
        t.setMatched(true);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }
}

