/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.util.PointD;

public class SbgnPDNode
extends CoSENode {
    public boolean visited;
    public boolean isDummyCompound;

    public SbgnPDNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
        this.visited = false;
        this.isDummyCompound = false;
    }

    public SbgnPDNode(LGraphManager gm, Point loc, Dimension size, LNode vNode, String type) {
        super(gm, loc, size, vNode);
        this.type = type;
        this.visited = false;
        this.label = vNode.label;
        this.isDummyCompound = false;
    }

    public void copyNode(SbgnPDNode s, LGraphManager graphManager) {
        this.type = s.type;
        this.label = s.label;
        this.setCenter(s.getCenterX(), s.getCenterY());
        this.setChild(s.getChild());
        this.setHeight(s.getHeight());
        this.setLocation(s.getLocation().x, s.getLocation().y);
        this.setNext(s.getNext());
        this.setOwner(s.getOwner());
        this.setPred1(s.getPred1());
        this.setPred2(s.getPred2());
        this.setWidth(s.getWidth());
    }

    public double getSpringForceX() {
        return this.springForceX;
    }

    public boolean isComplex() {
        return this.type.equalsIgnoreCase("complex");
    }

    public boolean isInputPort() {
        return this.type.equalsIgnoreCase("input_port");
    }

    public boolean isOutputPort() {
        return this.type.equalsIgnoreCase("output_port");
    }

    public boolean containsUnmarkedComplex() {
        if (this.getChild() == null) {
            return false;
        }
        for (Object child : this.getChild().getNodes()) {
            SbgnPDNode sbgnChild = (SbgnPDNode)child;
            if (!sbgnChild.isComplex() || sbgnChild.visited) continue;
            return true;
        }
        return false;
    }

    public void resetForces() {
        this.springForceX = 0.0;
        this.springForceY = 0.0;
        this.repulsionForceX = 0.0;
        this.repulsionForceY = 0.0;
    }

    protected void rotateNode(PointD origin, int rotationDegree) {
        PointD relativePt = new PointD(this.getCenterX() - origin.x, this.getCenterY() - origin.y);
        PointD rotatedPt = new PointD((double)(-Math.signum(rotationDegree)) * relativePt.y, (double)Math.signum(rotationDegree) * relativePt.x);
        this.setCenter(rotatedPt.x + origin.x, rotatedPt.y + origin.y);
        double newHeight = this.getWidth();
        double newWidth = this.getHeight();
        this.setWidth(newWidth);
        this.setHeight(newHeight);
    }

    public PointD calcAveragePoint() {
        PointD averagePnt = new PointD();
        for (Object o : this.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)o;
            if (edge.type.equals("rigid edge")) continue;
            averagePnt.x += edge.getOtherEnd(this).getCenterX();
            averagePnt.y += edge.getOtherEnd(this).getCenterY();
        }
        averagePnt.x /= (double)(this.getEdges().size() - 1);
        averagePnt.y /= (double)(this.getEdges().size() - 1);
        return averagePnt;
    }

    public void printForces() {
        System.out.println("springForceX: " + this.springForceX + " springForceY: " + this.springForceY + "\nrepulsionForceX: " + this.repulsionForceX + " repulsionForceY: " + this.repulsionForceY + "\ngravitationForceX: " + this.gravitationForceX + " gravitationForceY: " + this.gravitationForceY);
    }

    public ArrayList<SbgnPDNode> getChildrenNeighbors(String edgeType) {
        ArrayList<SbgnPDNode> neighbors = new ArrayList<SbgnPDNode>();
        for (int i = 0; i < this.getEdges().size(); ++i) {
            LEdge e2 = (LEdge)this.getEdges().get(i);
            if (!e2.getSource().equals(this) || e2.getTarget().equals(this)) continue;
            SbgnPDNode s = (SbgnPDNode)e2.getTarget();
            if (edgeType != null && e2.equals(edgeType)) {
                neighbors.add(s);
            }
            if (edgeType != null) continue;
            neighbors.add(s);
        }
        return neighbors;
    }

    @Override
    public void updateBounds() {
        assert (this.getChild() != null);
        if (this.getChild().getNodes().size() != 0) {
            LGraph childGraph = this.getChild();
            childGraph.updateBounds(true);
            this.rect.x = childGraph.getLeft();
            this.rect.y = childGraph.getTop();
            if (this.type != null && this.type.equals("dummy compound")) {
                this.setWidth(childGraph.getRight() - childGraph.getLeft());
                this.setHeight(childGraph.getBottom() - childGraph.getTop());
            } else {
                this.setWidth(childGraph.getRight() - childGraph.getLeft() + 10);
                this.setHeight(childGraph.getBottom() - childGraph.getTop() + 10 + 20);
            }
        }
    }
}

