/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util.alignment;

import org.ivis.util.alignment.ScoringScheme;

public class BasicScoringScheme
extends ScoringScheme {
    protected int match_reward;
    protected int mismatch_penalty;
    protected int gap_cost;
    protected int max_absolute_score;

    public BasicScoringScheme(int match_reward, int mismatch_penalty, int gap_cost) {
        this(match_reward, mismatch_penalty, gap_cost, true);
    }

    public BasicScoringScheme(int match_reward, int mismatch_penalty, int gap_cost, boolean case_sensitive) {
        super(case_sensitive);
        this.match_reward = match_reward;
        this.mismatch_penalty = mismatch_penalty;
        this.gap_cost = gap_cost;
        this.max_absolute_score = Math.abs(match_reward) >= Math.abs(mismatch_penalty) ? (Math.abs(match_reward) >= Math.abs(gap_cost) ? Math.abs(match_reward) : Math.abs(gap_cost)) : (Math.abs(mismatch_penalty) >= Math.abs(gap_cost) ? Math.abs(mismatch_penalty) : Math.abs(gap_cost));
    }

    @Override
    public int scoreSubstitution(char a, char b) {
        if (this.isCaseSensitive()) {
            if (a == b) {
                return this.match_reward;
            }
            return this.mismatch_penalty;
        }
        if (Character.toLowerCase(a) == Character.toLowerCase(b)) {
            return this.match_reward;
        }
        return this.mismatch_penalty;
    }

    @Override
    public int scoreInsertion(char a) {
        return this.gap_cost;
    }

    @Override
    public int scoreDeletion(char a) {
        return this.gap_cost;
    }

    @Override
    public int maxAbsoluteScore() {
        return this.max_absolute_score;
    }

    @Override
    public boolean isPartialMatchSupported() {
        return false;
    }

    public String toString() {
        return "Basic scoring scheme: match reward = " + this.match_reward + ", mismatch penalty = " + this.mismatch_penalty + ", gap cost = " + this.gap_cost;
    }
}

