/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath;

import java.util.List;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

class JaxenXPath
extends XPath {
    private static final String CVS_ID = "@(#) $RCSfile: JaxenXPath.java,v $ $Revision: 1.19 $ $Date: 2004/09/03 07:27:39 $ $Name: jdom_1_0 $";
    private transient JDOMXPath xPath;
    private Object currentContext;

    public JaxenXPath(String expr) throws JDOMException {
        this.setXPath(expr);
    }

    public void addNamespace(Namespace namespace2) {
        try {
            this.xPath.addNamespace(namespace2.getPrefix(), namespace2.getURI());
        }
        catch (JaxenException jaxenException) {}
    }

    public boolean equals(Object o) {
        if (o instanceof JaxenXPath) {
            JaxenXPath x = (JaxenXPath)o;
            return super.equals(o) && this.xPath.toString().equals(x.xPath.toString());
        }
        return false;
    }

    public String getXPath() {
        return this.xPath.toString();
    }

    public int hashCode() {
        return this.xPath.hashCode();
    }

    public Number numberValueOf(Object context) throws JDOMException {
        try {
            try {
                this.currentContext = context;
                Number number = this.xPath.numberValueOf(context);
                Object var4_3 = null;
                this.currentContext = null;
                return number;
            }
            catch (JaxenException ex1) {
                throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentContext = null;
            throw throwable;
        }
    }

    public List selectNodes(Object context) throws JDOMException {
        try {
            try {
                this.currentContext = context;
                List list = this.xPath.selectNodes(context);
                Object var4_3 = null;
                this.currentContext = null;
                return list;
            }
            catch (JaxenException ex1) {
                throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentContext = null;
            throw throwable;
        }
    }

    public Object selectSingleNode(Object context) throws JDOMException {
        try {
            try {
                this.currentContext = context;
                Object object = this.xPath.selectSingleNode(context);
                Object var4_3 = null;
                this.currentContext = null;
                return object;
            }
            catch (JaxenException ex1) {
                throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentContext = null;
            throw throwable;
        }
    }

    public void setVariable(String name, Object value) throws IllegalArgumentException {
        VariableContext o = this.xPath.getVariableContext();
        if (o instanceof SimpleVariableContext) {
            ((SimpleVariableContext)o).setVariableValue(null, name, value);
        }
    }

    private void setXPath(String expr) throws JDOMException {
        try {
            this.xPath = new JDOMXPath(expr);
            this.xPath.setNamespaceContext(new NSContext());
        }
        catch (Exception ex1) {
            throw new JDOMException("Invalid XPath expression: \"" + expr + "\"", ex1);
        }
    }

    public String toString() {
        return this.xPath.toString();
    }

    public String valueOf(Object context) throws JDOMException {
        try {
            try {
                this.currentContext = context;
                String string = this.xPath.stringValueOf(context);
                Object var4_3 = null;
                this.currentContext = null;
                return string;
            }
            catch (JaxenException ex1) {
                throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentContext = null;
            throw throwable;
        }
    }

    private class NSContext
    extends SimpleNamespaceContext {
        public String translateNamespacePrefixToUri(String prefix) {
            Object ctx;
            if (prefix == null || prefix.length() == 0) {
                return null;
            }
            String uri = super.translateNamespacePrefixToUri(prefix);
            if (uri == null && (ctx = JaxenXPath.this.currentContext) != null) {
                Namespace ns;
                Element elt = null;
                if (ctx instanceof Element) {
                    elt = (Element)ctx;
                } else if (ctx instanceof Attribute) {
                    elt = ((Attribute)ctx).getParent();
                } else if (ctx instanceof Content) {
                    elt = ((Content)ctx).getParentElement();
                } else if (ctx instanceof Document) {
                    elt = ((Document)ctx).getRootElement();
                }
                if (elt != null && (ns = elt.getNamespace(prefix)) != null) {
                    uri = ns.getURI();
                }
            }
            return uri;
        }
    }
}

