/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvConverter {
    public static final Log log = LogFactory.getLog(CvConverter.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final String UNIPROT = "uniprotkb";
    private static final String UNIPROT_MI = "MI:0486";
    public static final String INTACT = "intact";
    private static final String INTACT_MI = "MI:0469";
    public static final String CHEBI = "chebi";
    private static final String CHEBI_MI = "MI:0474";
    private static final String UNKNWON = "unknown";

    public <T extends CvType> CrossReference toMitab(T cv) throws TabConversionException {
        Collection<DbReference> refs;
        CrossReferenceImpl myCv = null;
        if (cv == null) {
            throw new IllegalArgumentException("You must give a non null JAXB OpenCvType.");
        }
        String name = null;
        String db = UNKNWON;
        String id = null;
        if (cv.hasNames()) {
            name = cv.getNames().getShortLabel();
        }
        if ((refs = XrefUtils.searchByDatabase(cv.getXref(), PSI_MI, PSI_MI_REF)).isEmpty()) {
            refs = XrefUtils.searchByType(cv.getXref(), IDENTITY, IDENTITY_REF);
        }
        if (!refs.isEmpty()) {
            db = PSI_MI;
            Iterator<DbReference> iterator = refs.iterator();
            id = iterator.next().getId();
            if (iterator.hasNext()) {
                log.warn(cv + " has " + refs.size() + " references to PSI-MI to choose from, picked the first one.");
                log.warn("1: " + id);
                int i = 1;
                while (iterator.hasNext()) {
                    DbReference dbReference = iterator.next();
                    log.warn(++i + ": " + dbReference.getId());
                }
            }
        }
        myCv = new CrossReferenceImpl(db, id, name);
        return myCv;
    }

    public <T extends CvType> T fromMitab(CrossReference tabCv, Class<T> clazz) throws XmlConversionException {
        CvType myCv = null;
        if (tabCv == null) {
            throw new IllegalArgumentException("You must give a non null tabCv CV.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null implementation class of CV");
        }
        Names names = null;
        Xref xref2 = null;
        if (tabCv.hasText()) {
            String shortLabel = tabCv.getText();
            names = new Names();
            names.setShortLabel(shortLabel);
        }
        if (tabCv.getIdentifier() != null) {
            String id = tabCv.getIdentifier();
            DbReference primaryRef = new DbReference(id, PSI_MI);
            primaryRef.setDbAc(PSI_MI_REF);
            primaryRef.setRefType(IDENTITY);
            primaryRef.setRefTypeAc(IDENTITY_REF);
            xref2 = new Xref(primaryRef);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            myCv = (CvType)constructor.newInstance(new Object[0]);
            if (names != null) {
                myCv.setNames(names);
            }
            if (xref2 != null) {
                myCv.setXref(xref2);
            }
        }
        catch (Exception e2) {
            throw new XmlConversionException("An exception was thrown while instanciating an xml.", e2);
        }
        return (T)myCv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends CvType> T fromMitab(Collection<CrossReference> crossReferences, Class<T> clazz) throws XmlConversionException {
        CvType myCv = null;
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null clazz Class.");
        }
        if (crossReferences == null) return (T)myCv;
        Names names = new Names();
        Xref xref2 = new Xref();
        boolean found = false;
        for (CrossReference crossReference : crossReferences) {
            if (!found && crossReference.getDatabase().equalsIgnoreCase(PSI_MI)) {
                names.setShortLabel(crossReference.getText());
                names.setFullName(crossReference.getText());
                DbReference dbRef = new DbReference();
                dbRef.setDb(PSI_MI);
                dbRef.setDbAc(PSI_MI_REF);
                dbRef.setId(crossReference.getIdentifier());
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                xref2.setPrimaryRef(dbRef);
                found = true;
                continue;
            }
            String database = crossReference.getDatabase();
            DbReference dbRef = new DbReference();
            dbRef.setId(crossReference.getIdentifier());
            dbRef.setDb(crossReference.getDatabase());
            if (database.equals(UNIPROT)) {
                dbRef.setDbAc(UNIPROT_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
            } else if (database.equals(CHEBI)) {
                dbRef.setDbAc(CHEBI_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
            } else if (database.equals(INTACT)) {
                dbRef.setDbAc(INTACT_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
            }
            xref2.getSecondaryRef().add(dbRef);
            if (!crossReference.hasText()) continue;
            Alias alias = new Alias(crossReference.getText());
            if (names.getAliases().isEmpty()) {
                names.getAliases().add(alias);
                continue;
            }
            if (names.getAliases().contains(alias)) continue;
            names.getAliases().add(alias);
        }
        if (found) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                myCv = (CvType)constructor.newInstance(new Object[0]);
                if (names != null) {
                    myCv.setNames(names);
                }
                if (xref2 == null) return (T)myCv;
                myCv.setXref(xref2);
                return (T)myCv;
            }
            catch (Exception e2) {
                throw new XmlConversionException("An exception was thrown while instanciating an xml.", e2);
            }
        } else {
            log.warn("No psi-mi CV term given, we can't create the xml CVType.");
        }
        return (T)myCv;
    }
}

