/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrefUtils {
    public static final Log log = LogFactory.getLog(XrefUtils.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public static Collection<DbReference> searchByDatabase(Xref xref2, String name, String miRef) {
        if (name == null && miRef == null) {
            throw new IllegalArgumentException("You must give either a name of an MI reference (or both).");
        }
        ArrayList<DbReference> collected = new ArrayList<DbReference>(2);
        List<DbReference> xrefs = XrefUtils.getAllDbReferences(xref2);
        for (DbReference reference : xrefs) {
            if (name != null) {
                if (!name.equalsIgnoreCase(reference.getDb())) continue;
                collected.add(reference);
                continue;
            }
            if (miRef == null || !miRef.equalsIgnoreCase(reference.getDbAc())) continue;
            collected.add(reference);
        }
        return collected;
    }

    public static Collection<DbReference> searchByType(Xref xref2, String name, String miRef) {
        if (name == null && miRef == null) {
            throw new IllegalArgumentException("You must give either a name of an MI reference (or both).");
        }
        ArrayList<DbReference> collected = new ArrayList<DbReference>(2);
        List<DbReference> xrefs = XrefUtils.getAllDbReferences(xref2);
        for (DbReference reference : xrefs) {
            if (miRef != null) {
                if (!miRef.equalsIgnoreCase(reference.getRefTypeAc())) continue;
                collected.add(reference);
                continue;
            }
            if (name == null || !name.equalsIgnoreCase(reference.getRefType())) continue;
            collected.add(reference);
        }
        return collected;
    }

    public static Collection<DbReference> searchByTypeAndDatabase(Xref xref2, String typeName, String typeMiRef, String dbName, String dbMiRef) {
        Collection<DbReference> typeRefs = XrefUtils.searchByType(xref2, typeName, typeMiRef);
        Collection<DbReference> dbRefs = XrefUtils.searchByDatabase(xref2, dbName, dbMiRef);
        ArrayList<DbReference> collected = new ArrayList<DbReference>(2);
        for (DbReference dbRef : dbRefs) {
            for (DbReference typeRef : typeRefs) {
                if (!typeRef.equals(dbRef)) continue;
                collected.add(typeRef);
            }
        }
        return collected;
    }

    public static List<DbReference> getAllDbReferences(Xref xref2) {
        ArrayList<DbReference> xrefs = new ArrayList<DbReference>();
        xrefs.add(xref2.getPrimaryRef());
        if (xref2.hasSecondaryRef()) {
            for (DbReference sec : xref2.getSecondaryRef()) {
                xrefs.add(sec);
            }
        }
        return xrefs;
    }

    public static boolean hasPsiId(Xref xref2, String psiRef) {
        if (psiRef == null || "".equals(psiRef.trim())) {
            throw new IllegalArgumentException("You must give a non null/empty PSI-MI id.");
        }
        if (xref2 == null) {
            return false;
        }
        List<DbReference> list = XrefUtils.getAllDbReferences(xref2);
        for (DbReference ref : list) {
            if (!PSI_MI.equalsIgnoreCase(ref.getDb()) && !PSI_MI_REF.equalsIgnoreCase(ref.getDbAc()) || !psiRef.equalsIgnoreCase(ref.getId())) continue;
            log.debug("Found Xref( psi-mi, " + psiRef + " )");
            return true;
        }
        return false;
    }

    public static List<DbReference> sortByIdentifier(Collection<DbReference> xrefs) {
        ArrayList<DbReference> sortedXrefs = new ArrayList<DbReference>(xrefs);
        Collections.sort(sortedXrefs, new Comparator<DbReference>(){

            @Override
            public int compare(DbReference x1, DbReference x2) {
                return x1.getId().compareTo(x2.getId());
            }
        });
        return sortedXrefs;
    }
}

