/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.Annotation;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Checksum;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Feature;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.Parameter;
import psidev.psi.mi.tab.model.builder.PsimiTabColumns;
import psidev.psi.mi.tab.model.builder.PsimiTabVersion;
import psidev.psi.mi.tab.utils.MitabEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MitabWriterUtils {
    private static final String MI_PREFIX = "MI";
    private static final String FIELD_DELIMITER = "|";
    private static final String EMPTY_COLUMN = "-";
    private static final String COLUMN_DELIMITER = "\t";
    private static final String EOF_DELIMITER = "\n";
    private static final String UNKNOWN = "unknown";

    public static String buildHeader(PsimiTabVersion version2) {
        return MitabWriterUtils.createMitabLine(PsimiTabColumns.getHeader(version2), version2);
    }

    public static String buildLine(BinaryInteraction interaction2, PsimiTabVersion version2) throws IllegalArgumentException {
        if (version2 == null) {
            throw new IllegalArgumentException("The version of MITAB can not be written");
        }
        String[] line = new String[version2.getNumberOfColumns()];
        Object interactorA = interaction2.getInteractorA();
        Object interactorB = interaction2.getInteractorB();
        switch (version2) {
            case v2_7: {
                if (interactorA != null) {
                    line[PsimiTabColumns.FEATURES_A.ordinal()] = MitabWriterUtils.joinFeatureCollection(((Interactor)interactorA).getFeatures());
                    line[PsimiTabColumns.STOICHIOMETRY_A.ordinal()] = MitabWriterUtils.joinStoichiometryCollection(((Interactor)interactorA).getStoichiometry());
                    line[PsimiTabColumns.PARTICIPANT_IDENT_MED_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getParticipantIdentificationMethods());
                } else {
                    line[PsimiTabColumns.FEATURES_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.STOICHIOMETRY_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.PARTICIPANT_IDENT_MED_A.ordinal()] = EMPTY_COLUMN;
                }
                if (interactorB != null) {
                    line[PsimiTabColumns.FEATURES_B.ordinal()] = MitabWriterUtils.joinFeatureCollection(((Interactor)interactorB).getFeatures());
                    line[PsimiTabColumns.STOICHIOMETRY_B.ordinal()] = MitabWriterUtils.joinStoichiometryCollection(((Interactor)interactorB).getStoichiometry());
                    line[PsimiTabColumns.PARTICIPANT_IDENT_MED_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getParticipantIdentificationMethods());
                } else {
                    line[PsimiTabColumns.FEATURES_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.STOICHIOMETRY_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.PARTICIPANT_IDENT_MED_B.ordinal()] = EMPTY_COLUMN;
                }
            }
            case v2_6: {
                if (interactorA != null) {
                    line[PsimiTabColumns.BIOROLE_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getBiologicalRoles());
                    line[PsimiTabColumns.EXPROLE_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getExperimentalRoles());
                    line[PsimiTabColumns.INTERACTOR_TYPE_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getInteractorTypes());
                    line[PsimiTabColumns.XREFS_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getXrefs());
                    line[PsimiTabColumns.ANNOTATIONS_A.ordinal()] = MitabWriterUtils.joinAnnotationsCollection(((Interactor)interactorA).getAnnotations());
                    line[PsimiTabColumns.CHECKSUM_A.ordinal()] = MitabWriterUtils.joinChecksumCollection(((Interactor)interactorA).getChecksums());
                } else {
                    line[PsimiTabColumns.BIOROLE_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.EXPROLE_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.INTERACTOR_TYPE_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.XREFS_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ANNOTATIONS_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.CHECKSUM_A.ordinal()] = EMPTY_COLUMN;
                }
                if (interactorB != null) {
                    line[PsimiTabColumns.BIOROLE_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getBiologicalRoles());
                    line[PsimiTabColumns.EXPROLE_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getExperimentalRoles());
                    line[PsimiTabColumns.INTERACTOR_TYPE_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getInteractorTypes());
                    line[PsimiTabColumns.XREFS_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getXrefs());
                    line[PsimiTabColumns.ANNOTATIONS_B.ordinal()] = MitabWriterUtils.joinAnnotationsCollection(((Interactor)interactorB).getAnnotations());
                    line[PsimiTabColumns.CHECKSUM_B.ordinal()] = MitabWriterUtils.joinChecksumCollection(((Interactor)interactorB).getChecksums());
                } else {
                    line[PsimiTabColumns.BIOROLE_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.EXPROLE_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.INTERACTOR_TYPE_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.XREFS_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ANNOTATIONS_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.CHECKSUM_B.ordinal()] = EMPTY_COLUMN;
                }
                line[PsimiTabColumns.COMPLEX_EXPANSION.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getComplexExpansion());
                line[PsimiTabColumns.XREFS_I.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getXrefs());
                line[PsimiTabColumns.ANNOTATIONS_I.ordinal()] = MitabWriterUtils.joinAnnotationsCollection(interaction2.getAnnotations());
                line[PsimiTabColumns.HOST_ORGANISM.ordinal()] = MitabWriterUtils.joinOrganism(interaction2.getHostOrganism());
                line[PsimiTabColumns.PARAMETERS_I.ordinal()] = MitabWriterUtils.joinParametersCollection(interaction2.getParameters());
                line[PsimiTabColumns.CREATION_DATE.ordinal()] = MitabWriterUtils.joinDateCollection(interaction2.getCreationDate());
                line[PsimiTabColumns.UPDATE_DATE.ordinal()] = MitabWriterUtils.joinDateCollection(interaction2.getUpdateDate());
                line[PsimiTabColumns.CHECKSUM_I.ordinal()] = MitabWriterUtils.joinChecksumCollection(interaction2.getChecksums());
                line[PsimiTabColumns.NEGATIVE.ordinal()] = MitabWriterUtils.createNegative(interaction2.isNegativeInteraction());
            }
            case v2_5: {
                if (interactorA != null) {
                    line[PsimiTabColumns.ID_INTERACTOR_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getIdentifiers());
                    line[PsimiTabColumns.ALTID_INTERACTOR_A.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorA).getAlternativeIdentifiers());
                    line[PsimiTabColumns.ALIAS_INTERACTOR_A.ordinal()] = MitabWriterUtils.joinAliasCollection(((Interactor)interactorA).getAliases());
                    line[PsimiTabColumns.TAXID_A.ordinal()] = MitabWriterUtils.joinOrganism(((Interactor)interactorA).getOrganism());
                } else {
                    line[PsimiTabColumns.ID_INTERACTOR_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ALTID_INTERACTOR_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ALIAS_INTERACTOR_A.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.TAXID_A.ordinal()] = EMPTY_COLUMN;
                }
                if (interactorB != null) {
                    line[PsimiTabColumns.ID_INTERACTOR_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getIdentifiers());
                    line[PsimiTabColumns.ALTID_INTERACTOR_B.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(((Interactor)interactorB).getAlternativeIdentifiers());
                    line[PsimiTabColumns.ALIAS_INTERACTOR_B.ordinal()] = MitabWriterUtils.joinAliasCollection(((Interactor)interactorB).getAliases());
                    line[PsimiTabColumns.TAXID_B.ordinal()] = MitabWriterUtils.joinOrganism(((Interactor)interactorB).getOrganism());
                } else {
                    line[PsimiTabColumns.ID_INTERACTOR_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ALTID_INTERACTOR_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.ALIAS_INTERACTOR_B.ordinal()] = EMPTY_COLUMN;
                    line[PsimiTabColumns.TAXID_B.ordinal()] = EMPTY_COLUMN;
                }
                line[PsimiTabColumns.INT_DET_METHOD.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getDetectionMethods());
                line[PsimiTabColumns.PUB_AUTH.ordinal()] = MitabWriterUtils.joinAuthorCollection(interaction2.getAuthors());
                line[PsimiTabColumns.PUB_ID.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getPublications());
                line[PsimiTabColumns.INTERACTION_TYPE.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getInteractionTypes());
                line[PsimiTabColumns.SOURCE.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getSourceDatabases());
                line[PsimiTabColumns.INTERACTION_ID.ordinal()] = MitabWriterUtils.joinCrossReferencStyleCollection(interaction2.getInteractionAcs());
                line[PsimiTabColumns.CONFIDENCE.ordinal()] = MitabWriterUtils.joinConfidenceCollection(interaction2.getConfidenceValues());
                break;
            }
            default: {
                throw new IllegalArgumentException("This version of MITAB is not supported");
            }
        }
        return MitabWriterUtils.createMitabLine(line, version2);
    }

    public static String joinFeatureCollection(List<Feature> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Feature> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Feature field = iterator.next();
                String ranges = StringUtils.join(field.getRanges(), ",");
                sb.append(MitabWriterUtils.joinAttributes(field.getFeatureType(), ranges, field.getText()));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinAnnotationsCollection(List<Annotation> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Annotation> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String text;
                Annotation field = iterator.next();
                String topic = field.getTopic();
                if (topic != null) {
                    topic = topic.replaceAll("\\p{Cntrl}", " ");
                }
                if ((text = field.getText()) != null) {
                    text = text.replaceAll("\\p{Cntrl}", " ");
                }
                sb.append(MitabWriterUtils.joinAttributes(topic, text, null));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinStoichiometryCollection(List<Integer> stoichiometry) {
        StringBuilder sb = new StringBuilder();
        if (stoichiometry != null && !stoichiometry.isEmpty()) {
            Iterator<Integer> iterator = stoichiometry.iterator();
            while (iterator.hasNext()) {
                Integer field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(null, field.toString(), null));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String createNegative(Boolean negativeInteraction) {
        String negative = negativeInteraction == null ? EMPTY_COLUMN : negativeInteraction.toString();
        return negative;
    }

    public static String joinChecksumCollection(List<Checksum> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Checksum> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Checksum field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(field.getMethodName(), field.getChecksum(), null));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinParametersCollection(List<Parameter> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Parameter> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Parameter field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(field.getType(), field.getValue(), field.getUnit()));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinOrganism(Organism organism) {
        String result = organism != null && !organism.getIdentifiers().isEmpty() ? MitabWriterUtils.joinCrossReferencStyleCollection(organism.getIdentifiers()) : EMPTY_COLUMN;
        return result;
    }

    public static String joinAuthorCollection(List<Author> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Author> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Author field = iterator.next();
                sb.append(field.getName());
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinConfidenceCollection(List<Confidence> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Confidence> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Confidence field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(field.getType(), field.getValue(), field.getText()));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinCrossReferencStyleCollection(List<CrossReference> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<CrossReference> iterator = collection.iterator();
            while (iterator.hasNext()) {
                CrossReference field = iterator.next();
                if (field instanceof CrossReference) {
                    CrossReference crossReference = field;
                    if (crossReference.getDatabase() == null) {
                        crossReference.setDatabase(UNKNOWN);
                    }
                    sb.append(MitabWriterUtils.joinAttributes(crossReference.getDatabase(), crossReference.getIdentifier(), crossReference.getText()));
                }
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinAliasCollection(List<Alias> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            Iterator<Alias> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Alias field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(field.getDbSource(), field.getName(), field.getAliasType()));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinDateCollection(List<Date> collection) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        if (collection != null && !collection.isEmpty()) {
            Iterator<Date> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Date field = iterator.next();
                sb.append(MitabWriterUtils.joinAttributes(null, formatter.format((Object)field), null));
                if (!iterator.hasNext()) continue;
                sb.append(FIELD_DELIMITER);
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String joinAttributes(String type, String value, String description) {
        StringBuilder sb = new StringBuilder();
        boolean psiCvTerm = false;
        if (type == null && value == null && description == null) {
            return EMPTY_COLUMN;
        }
        if (type != null) {
            if (MI_PREFIX.equals(type)) {
                type = "psi-mi";
                psiCvTerm = true;
            }
            sb.append(MitabEscapeUtils.escapeFieldElement(type));
            sb.append(':');
        }
        if (value != null) {
            if (type == null && description == null) {
                sb.append(MitabEscapeUtils.escapeFieldElement(value));
            } else if (psiCvTerm) {
                sb.append(MitabEscapeUtils.escapeFieldElement("MI:" + value));
            } else {
                sb.append(MitabEscapeUtils.escapeFieldElement(value));
            }
        }
        if (description != null) {
            sb.append('(');
            sb.append(MitabEscapeUtils.escapeFieldElement(description));
            sb.append(')');
        }
        return sb.toString();
    }

    public static String createMitabLine(String[] columns, PsimiTabVersion version2) {
        StringBuilder sb = new StringBuilder();
        int numberOfColumns = version2.getNumberOfColumns();
        sb.append(columns[0]);
        for (int i = 1; i < numberOfColumns; ++i) {
            sb.append(COLUMN_DELIMITER);
            sb.append(columns[i]);
        }
        sb.append(EOF_DELIMITER);
        return sb.toString();
    }
}

