/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.utils;

import java.util.ArrayList;
import java.util.List;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.OrganismImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryInteractionHandler<T extends BinaryInteraction> {
    public abstract T newBinaryInteraction(Interactor var1, Interactor var2);

    public abstract Interactor newInteractor(List<CrossReference> var1);

    public T merge(T bi1, T bi2) {
        Interactor merged = this.cloneBinaryInteraction(bi1);
        merged.setInteractorA((Interactor)this.mergeInteractorA((Interactor)bi1.getInteractorA(), (Interactor)bi2.getInteractorA()));
        merged.setInteractorB((Interactor)this.mergeInteractorB((Interactor)bi1.getInteractorB(), (Interactor)bi2.getInteractorB()));
        this.populateBinaryInteraction(bi2, merged);
        return (T)merged;
    }

    public T cloneBinaryInteraction(T interaction2) {
        T clone = this.newBinaryInteraction(this.cloneInteractor((Interactor)interaction2.getInteractorA()), this.cloneInteractor((Interactor)interaction2.getInteractorB()));
        this.populateBinaryInteraction(interaction2, clone);
        return clone;
    }

    protected void populateBinaryInteraction(T source, T target) {
        target.getPublications().addAll(source.getPublications());
        target.getAuthors().addAll(source.getAuthors());
        target.getInteractionTypes().addAll(source.getInteractionTypes());
        target.getDetectionMethods().addAll(source.getDetectionMethods());
        target.getConfidenceValues().addAll(source.getConfidenceValues());
        target.getSourceDatabases().addAll(source.getSourceDatabases());
        target.getInteractionAcs().addAll(source.getInteractionAcs());
        target.getAnnotations().addAll(source.getAnnotations());
        target.getChecksums().addAll(source.getChecksums());
        target.getComplexExpansion().addAll(source.getComplexExpansion());
        target.getCreationDate().addAll(source.getCreationDate());
        target.getParameters().addAll(source.getParameters());
        if (target.getHostOrganism() == null) {
            target.setHostOrganism(source.getHostOrganism());
        } else if (source.getHostOrganism() != null) {
            target.getHostOrganism().getIdentifiers().addAll(source.getHostOrganism().getIdentifiers());
        }
    }

    protected Interactor mergeInteractorA(Interactor i1, Interactor i2) {
        return this.mergeInteractors(i1, i2);
    }

    protected Interactor mergeInteractorB(Interactor i1, Interactor i2) {
        return this.mergeInteractors(i1, i2);
    }

    protected Interactor mergeInteractors(Interactor i1, Interactor i2) {
        if (i1 != null && i2 != null) {
            Interactor merged = this.cloneInteractor(i1);
            merged.getIdentifiers().addAll(i2.getIdentifiers());
            this.populateInteractor(i2, merged);
            return merged;
        }
        if (i1 != null) {
            return i1;
        }
        return i2;
    }

    public Interactor cloneInteractor(Interactor interactor) {
        if (interactor == null) {
            return null;
        }
        Interactor clone = this.newInteractor(new ArrayList<CrossReference>(interactor.getIdentifiers()));
        this.populateInteractor(interactor, clone);
        return clone;
    }

    protected void populateInteractor(Interactor source, Interactor target) {
        if (target != null && source != null) {
            target.getAlternativeIdentifiers().addAll(source.getAlternativeIdentifiers());
            target.getAliases().addAll(source.getAliases());
            if (!target.hasOrganism()) {
                target.setOrganism(new OrganismImpl());
            }
            if (source.hasOrganism()) {
                target.getOrganism().getIdentifiers().addAll(source.getOrganism().getIdentifiers());
            }
            target.getAnnotations().addAll(source.getAnnotations());
            target.getBiologicalRoles().addAll(source.getBiologicalRoles());
            target.getChecksums().addAll(source.getChecksums());
            target.getFeatures().addAll(source.getFeatures());
            target.getInteractorTypes().addAll(source.getInteractorTypes());
            target.getParticipantIdentificationMethods().addAll(source.getParticipantIdentificationMethods());
            target.getStoichiometry().addAll(source.getStoichiometry());
            target.getXrefs().addAll(source.getXrefs());
        }
    }
}

