/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlForm;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.AttributeConverter;
import psidev.psi.mi.xml.converter.impl253.AvailabilityConverter;
import psidev.psi.mi.xml.converter.impl253.ConfidenceConverter;
import psidev.psi.mi.xml.converter.impl253.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl253.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.impl253.InferredInteractionConverter;
import psidev.psi.mi.xml.converter.impl253.InteractionParameterConverter;
import psidev.psi.mi.xml.converter.impl253.NamesConverter;
import psidev.psi.mi.xml.converter.impl253.ParticipantConverter;
import psidev.psi.mi.xml.converter.impl253.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml253.jaxb.AttributeListType;
import psidev.psi.mi.xml253.jaxb.ConfidenceListType;
import psidev.psi.mi.xml253.jaxb.CvType;
import psidev.psi.mi.xml253.jaxb.EntryType;
import psidev.psi.mi.xml253.jaxb.ExperimentType;
import psidev.psi.mi.xml253.jaxb.InteractionElementType;
import psidev.psi.mi.xml253.jaxb.ParticipantType;

public class InteractionConverter {
    public static final Log log = LogFactory.getLog(InteractionConverter.class);
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private ConfidenceConverter confidenceConverter = new ConfidenceConverter();
    private ParticipantConverter participantConverter = new ParticipantConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private InteractionParameterConverter parameterConverter = new InteractionParameterConverter();
    private InferredInteractionConverter inferredInteractionConverter = new InferredInteractionConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.parameterConverter.setDAOFactory(factory);
        this.confidenceConverter.setDAOFactory(factory);
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.participantConverter.setDAOFactory(factory);
        this.experimentDescriptionConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Interaction fromJaxb(EntryType.InteractionList.Interaction jInteraction) throws ConverterException {
        if (jInteraction == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interaction.");
        }
        this.checkDependencies();
        Interaction mInteraction = new Interaction();
        mInteraction.setId(jInteraction.getId());
        mInteraction.setImexId(jInteraction.getImexId());
        if (jInteraction.getNames() != null) {
            mInteraction.setNames(this.namesConverter.fromJaxb(jInteraction.getNames()));
        }
        if (jInteraction.getXref() != null) {
            mInteraction.setXref(this.xrefConverter.fromJaxb(jInteraction.getXref()));
        }
        if (jInteraction.getAvailability() != null) {
            mInteraction.setAvailability(this.availabilityConverter.fromJaxb(jInteraction.getAvailability()));
        }
        if (jInteraction.getExperimentList() != null) {
            for (Serializable o : jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions()) {
                log.debug("Reading object of type: " + o.getClass());
                ExperimentDescription mExperiment = null;
                ExperimentRef experimentRef = null;
                if (o instanceof ExperimentType) {
                    log.debug("Found an experiment");
                    mExperiment = this.experimentDescriptionConverter.fromJaxb((ExperimentType)o);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    experimentDAO.store(mExperiment);
                } else if (o instanceof Integer) {
                    Integer ref = (Integer)o;
                    experimentRef = new ExperimentRef(ref);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    mExperiment = experimentDAO.retreive((Integer)o);
                } else {
                    throw new IllegalStateException("Expected object type: {ExperimentType, Integer}, found: " + o.getClass().getName());
                }
                if (mExperiment == null) {
                    mInteraction.getExperimentRefs().add(experimentRef);
                    continue;
                }
                mInteraction.getExperiments().add(mExperiment);
            }
        }
        if (jInteraction.getParticipantList() != null) {
            for (ParticipantType jParticipant : jInteraction.getParticipantList().getParticipants()) {
                Participant participant = this.participantConverter.fromJaxb(jParticipant);
                mInteraction.getParticipants().add(participant);
            }
        }
        if (jInteraction.getInferredInteractionList() != null) {
            for (InteractionElementType.InferredInteractionList.InferredInteraction jInferredInteraction : jInteraction.getInferredInteractionList().getInferredInteractions()) {
                mInteraction.getInferredInteractions().add(this.inferredInteractionConverter.fromJaxb(jInferredInteraction));
            }
        }
        for (CvType jIntereractionType : jInteraction.getInteractionTypes()) {
            mInteraction.getInteractionTypes().add(this.cvTypeConverter.fromJaxb(jIntereractionType, InteractionType.class));
        }
        if (jInteraction.isModelled() != null) {
            mInteraction.setModelled(jInteraction.isModelled());
        } else {
            mInteraction.setModelled(false);
        }
        if (jInteraction.isIntraMolecular() != null) {
            mInteraction.setIntraMolecular(jInteraction.isIntraMolecular());
        } else {
            mInteraction.setIntraMolecular(false);
        }
        if (jInteraction.isNegative() != null) {
            mInteraction.setNegative(jInteraction.isNegative());
        } else {
            mInteraction.setNegative(false);
        }
        if (jInteraction.getConfidenceList() != null) {
            for (ConfidenceListType.Confidence jConfidence : jInteraction.getConfidenceList().getConfidences()) {
                mInteraction.getConfidences().add(this.confidenceConverter.fromJaxb(jConfidence));
            }
        }
        if (jInteraction.getParameterList() != null) {
            for (InteractionElementType.ParameterList.Parameter jParameter : jInteraction.getParameterList().getParameters()) {
                mInteraction.getParameters().add(this.parameterConverter.fromJaxb(jParameter));
            }
        }
        if (jInteraction.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jInteraction.getAttributeList().getAttributes()) {
                mInteraction.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        PsiDAO<Interaction> interactionDAO = this.factory.getInteractionDAO();
        interactionDAO.store(mInteraction);
        return mInteraction;
    }

    public EntryType.InteractionList.Interaction toJaxb(Interaction mInteraction) throws ConverterException {
        if (mInteraction == null) {
            throw new IllegalArgumentException("You must give a non null model Interaction.");
        }
        this.checkDependencies();
        EntryType.InteractionList.Interaction jInteraction = new EntryType.InteractionList.Interaction();
        jInteraction.setId(mInteraction.getId());
        jInteraction.setImexId(mInteraction.getImexId());
        if (mInteraction.hasNames()) {
            jInteraction.setNames(this.namesConverter.toJaxb(mInteraction.getNames()));
        }
        if (mInteraction.hasXref()) {
            jInteraction.setXref(this.xrefConverter.toJaxb(mInteraction.getXref()));
        }
        if (mInteraction.hasAvailability()) {
            jInteraction.setAvailability(this.availabilityConverter.toJaxb(mInteraction.getAvailability()));
        }
        if (PsimiXmlForm.FORM_COMPACT.equals((Object)ConverterContext.getInstance().getConverterConfig().getXmlForm()) && mInteraction.hasExperimentRefs()) {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new InteractionElementType.ExperimentList());
            }
            List<Serializable> ids = jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions();
            for (ExperimentRef mExperiment : mInteraction.getExperimentRefs()) {
                if (ids.contains(mExperiment.getRef())) continue;
                ids.add(Integer.valueOf(mExperiment.getRef()));
            }
        } else {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new InteractionElementType.ExperimentList());
            }
            for (ExperimentDescription mExperiment : mInteraction.getExperiments()) {
                ExperimentType exp = this.experimentDescriptionConverter.toJaxb(mExperiment);
                List<Serializable> ids = jInteraction.getExperimentList().getExperimentRevesAndExperimentDescriptions();
                if (PsimiXmlForm.FORM_COMPACT == ConverterContext.getInstance().getConverterConfig().getXmlForm()) {
                    if (ids.contains(mExperiment.getId())) continue;
                    ids.add(Integer.valueOf(mExperiment.getId()));
                    continue;
                }
                if (ids.contains(exp)) continue;
                ids.add(exp);
            }
        }
        if (mInteraction.getParticipants() != null) {
            if (jInteraction.getParticipantList() == null) {
                jInteraction.setParticipantList(new InteractionElementType.ParticipantList());
            }
            for (Participant mParticipant : mInteraction.getParticipants()) {
                jInteraction.getParticipantList().getParticipants().add(this.participantConverter.toJaxb(mParticipant));
            }
        }
        if (mInteraction.hasInferredInteractions()) {
            if (jInteraction.getInferredInteractionList() == null) {
                jInteraction.setInferredInteractionList(new InteractionElementType.InferredInteractionList());
            }
            for (InferredInteraction inferredInteraction : mInteraction.getInferredInteractions()) {
                jInteraction.getInferredInteractionList().getInferredInteractions().add(this.inferredInteractionConverter.toJaxb(inferredInteraction));
            }
        }
        if (mInteraction.hasInteractionTypes()) {
            for (InteractionType mInteractionType : mInteraction.getInteractionTypes()) {
                jInteraction.getInteractionTypes().add(this.cvTypeConverter.toJaxb(mInteractionType));
            }
        }
        if (mInteraction.hasParameters()) {
            if (jInteraction.getParameterList() == null) {
                jInteraction.setParameterList(new InteractionElementType.ParameterList());
            }
            for (Parameter mParameter : mInteraction.getParameters()) {
                jInteraction.getParameterList().getParameters().add(this.parameterConverter.toJaxb(mParameter));
            }
        }
        jInteraction.setIntraMolecular(mInteraction.isIntraMolecular());
        jInteraction.setModelled(mInteraction.isModelled());
        jInteraction.setNegative(mInteraction.isNegative());
        if (mInteraction.hasConfidences()) {
            if (jInteraction.getConfidenceList() == null) {
                jInteraction.setConfidenceList(new ConfidenceListType());
            }
            for (Confidence mConfidence : mInteraction.getConfidences()) {
                jInteraction.getConfidenceList().getConfidences().add(this.confidenceConverter.toJaxb(mConfidence));
            }
        }
        if (mInteraction.hasAttributes()) {
            if (jInteraction.getAttributeList() == null) {
                jInteraction.setAttributeList(new AttributeListType());
            }
            for (Attribute mAttribute : mInteraction.getAttributes()) {
                jInteraction.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        return jInteraction;
    }
}

