/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.IndexedSeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentMerger {
    public Set parseIgnorePositions(File maskFileName) throws IOException {
        String line;
        HashSet<Integer> ignorePositions = new HashSet<Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(maskFileName));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            ignorePositions.add(Integer.parseInt(line));
        }
        return ignorePositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<File, String> mergeAlignment(List<File> alignmentFiles, File mergeToFile, Set<Integer> ignoredPositions) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(mergeToFile));
        try {
            Map<File, String> map = AlignmentMerger.mergeAlignment(alignmentFiles, out, ignoredPositions);
            return map;
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static Map<File, String> mergeAlignment(List<File> alignmentFiles, OutputStream os, Set<Integer> ignoredPositions) throws IOException {
        HashMap<File, String> skippedFiles = new HashMap<File, String>();
        Map<File, char[]> refSeqMap = AlignmentMerger.getReferenceSeqs(alignmentFiles, ignoredPositions, skippedFiles);
        int[] insertLengths = AlignmentMerger.getInserts(refSeqMap.values());
        FastaWriter mergeStream = new FastaWriter(os);
        String mergedRefSeq = null;
        for (File f : refSeqMap.keySet()) {
            System.err.println("Merging file " + f);
            mergedRefSeq = AlignmentMerger.merge(f, mergeStream, refSeqMap.get(f), insertLengths);
        }
        mergeStream.writeSeq("#=GC_RF", mergedRefSeq);
        mergeStream.close();
        return skippedFiles;
    }

    private static Map<File, char[]> getReferenceSeqs(List<File> alignmentFiles, Set<Integer> ignoredPositions, Map<File, String> skippedFiles) throws IOException {
        LinkedHashMap<File, char[]> refSeqMap = new LinkedHashMap<File, char[]>();
        int realModelLength = -1;
        for (File alignmentFile : alignmentFiles) {
            if (alignmentFile.isFile()) {
                String refSeqId;
                SequenceFormat format = SeqUtils.guessFileFormat((File)alignmentFile);
                if (format == SequenceFormat.FASTA) {
                    refSeqId = "#=GC_RF";
                } else if (format == SequenceFormat.STK) {
                    refSeqId = "#=GC RF";
                } else {
                    skippedFiles.put(alignmentFile, "Unprocessable sequence format " + format);
                    continue;
                }
                char[] refSeq = null;
                System.err.println("Extracting reference from " + alignmentFile + " (format=" + format + ")");
                try {
                    if (format == SequenceFormat.FASTA) {
                        Sequence seq;
                        int c;
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(alignmentFile));
                        while (is.available() > 10000) {
                            is.skip(is.available() - 10000);
                        }
                        is.mark(1);
                        while ((c = is.read()) != -1 && (char)c != '>') {
                            is.mark(1);
                        }
                        is.reset();
                        SequenceReader reader = new SequenceReader((InputStream)is);
                        while ((seq = reader.readNextSequence()) != null) {
                            if (!seq.getSeqName().equals(refSeqId)) continue;
                            refSeq = seq.getSeqString().toCharArray();
                            break;
                        }
                        reader.close();
                    } else {
                        IndexedSeqReader reader = new IndexedSeqReader(alignmentFile);
                        refSeq = reader.readSeq(refSeqId).getSeqString().toCharArray();
                        reader.close();
                    }
                    if (refSeq == null) {
                        throw new IOException();
                    }
                    for (int index = 0; index < refSeq.length; ++index) {
                        if (refSeq[index] != '~') continue;
                        refSeq[index] = 46;
                    }
                }
                catch (IOException ignore) {
                    skippedFiles.put(alignmentFile, "Reference sequence \"" + refSeqId + "\" not found");
                    continue;
                }
                int modelLength = 0;
                for (int index = 0; index < refSeq.length; ++index) {
                    if (refSeq[index] != '.') {
                        ++modelLength;
                    }
                    if (!ignoredPositions.contains(modelLength)) continue;
                    refSeq[index] = 46;
                }
                if (realModelLength == -1) {
                    realModelLength = modelLength;
                } else if (realModelLength != modelLength) {
                    skippedFiles.put(alignmentFile, "Model length [" + modelLength + "] doesn't match expected [" + realModelLength + "]");
                    continue;
                }
                refSeqMap.put(alignmentFile, refSeq);
                continue;
            }
            skippedFiles.put(alignmentFile, "Not a file");
        }
        return refSeqMap;
    }

    private static int[] getInserts(Collection<char[]> refSeqs) throws IOException {
        int[] insertLengths = null;
        for (char[] refSeq : refSeqs) {
            if (insertLengths == null) {
                int modelLength = new String(refSeq).replace(".", "").length();
                insertLengths = new int[modelLength + 1];
            }
            int modelPosition = 0;
            int insertLength = 0;
            for (int index = 0; index < refSeq.length; ++index) {
                if (refSeq[index] == '.') {
                    ++insertLength;
                    continue;
                }
                if (insertLength > insertLengths[modelPosition]) {
                    insertLengths[modelPosition] = insertLength;
                }
                ++modelPosition;
                insertLength = 0;
            }
            if (insertLength <= insertLengths[modelPosition]) continue;
            insertLengths[modelPosition] = insertLength;
        }
        return insertLengths;
    }

    private static String merge(File alignmentFile, FastaWriter mergeStream, char[] refSeq, int[] insertLengths) throws IOException {
        Sequence seq;
        SequenceReader reader = new SequenceReader(alignmentFile);
        StringBuilder mergedRef = new StringBuilder();
        String[] paddings = new String[insertLengths.length];
        int modelPosition = 0;
        int insertLength = 0;
        for (int index = 0; index < refSeq.length; ++index) {
            if (refSeq[index] == '.') {
                ++insertLength;
                mergedRef.append(".");
                continue;
            }
            StringBuilder insertPadding = new StringBuilder();
            for (int ins = insertLength; ins < insertLengths[modelPosition]; ++ins) {
                insertPadding.append('.');
            }
            paddings[modelPosition] = insertPadding.toString();
            mergedRef.append((CharSequence)insertPadding);
            mergedRef.append("x");
            ++modelPosition;
            insertLength = 0;
        }
        StringBuilder insertPadding = new StringBuilder();
        for (int ins = insertLength; ins < insertLengths[modelPosition]; ++ins) {
            insertPadding.append('.');
        }
        paddings[modelPosition] = insertPadding.toString();
        mergedRef.append((CharSequence)insertPadding);
        while ((seq = reader.readNextSequence()) != null) {
            if (seq.getSeqName().startsWith("#")) continue;
            StringBuilder modifiedSeq = new StringBuilder();
            char[] bases = seq.getSeqString().toCharArray();
            modelPosition = 0;
            if (bases.length != refSeq.length) {
                throw new IOException("Sequence " + seq.getSeqName() + " in file " + alignmentFile.getName() + "'s length [" + bases.length + "] isn't the same as it's ref seq length [" + refSeq.length + "]");
            }
            for (int b = 0; b < bases.length; ++b) {
                char base = bases[b];
                if (base == 'u' || base == 'U') {
                    base = 't';
                }
                if (refSeq[b] == '.') {
                    modifiedSeq.append(Character.toLowerCase(base));
                    continue;
                }
                modifiedSeq.append(paddings[modelPosition]).append(Character.toUpperCase(base));
                ++modelPosition;
            }
            modifiedSeq.append(paddings[modelPosition]);
            mergeStream.writeSeq(seq.getSeqName(), seq.getDesc(), modifiedSeq.toString());
        }
        reader.close();
        return mergedRef.toString();
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage: java AlignmentMerger <alignfiledir> <outfile.fasta> [ <mask_file>] \n  This program reads in all the files from the input directory and merges the alignment into one single file\n  stkdir contains a list of aligned stk files to be merged \n  maskfile contains the model positions to be ignored";
        if (args.length != 2 && args.length != 3) {
            throw new IllegalArgumentException(usage);
        }
        String stkdir = args[0];
        String outfile = args[1];
        AlignmentMerger parser = new AlignmentMerger();
        HashSet<Integer> ignorePositions = new HashSet();
        if (args.length == 3) {
            ignorePositions = parser.parseIgnorePositions(new File(args[2]));
        }
        Map<File, String> notMerged = AlignmentMerger.mergeAlignment(Arrays.asList(new File(stkdir).listFiles()), new File(outfile), ignorePositions);
        for (File f : notMerged.keySet()) {
            System.err.println("Did not merge " + f + " beacse " + notMerged.get(f));
        }
    }
}

