/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm.scoring;

import edu.msu.cme.rdp.alignment.hmm.ProfileHMM;
import edu.msu.cme.rdp.alignment.hmm.TSC;
import edu.msu.cme.rdp.alignment.hmm.XSC;
import edu.msu.cme.rdp.alignment.hmm.XSTATES;
import edu.msu.cme.rdp.alignment.hmm.scoring.HMMScorer;

public final class ViterbiScorer
extends HMMScorer {
    public ViterbiScorer(ProfileHMM hmm) {
        this(hmm, -1);
    }

    public ViterbiScorer(ProfileHMM hmm, int startingState) {
        super(hmm, startingState);
    }

    protected final void initializeSM() {
        for (int k = 0; k <= this.modelLength; ++k) {
            if (k == this.startingState - 1 || this.startingState == -1) {
                this.mmx(0, k, 0.0);
                this.imx(0, k, 0.0);
                this.dmx(0, k, 0.0);
                continue;
            }
            this.mmx(0, k, Double.NEGATIVE_INFINITY);
            this.imx(0, k, Double.NEGATIVE_INFINITY);
            this.dmx(0, k, Double.NEGATIVE_INFINITY);
        }
        this.xmx(0, XSTATES.N, 0.0);
        this.xmx(0, XSTATES.B, this.hmm.xsc(XSTATES.N, XSC.MOVE));
        this.xmx(0, XSTATES.E, Double.NEGATIVE_INFINITY);
        this.xmx(0, XSTATES.C, Double.NEGATIVE_INFINITY);
        this.xmx(0, XSTATES.J, Double.NEGATIVE_INFINITY);
    }

    public final void consume(char b) {
        double sc;
        this.extend();
        double lastMaxScore = Double.NEGATIVE_INFINITY;
        double[] mx = this.mmx(this.i);
        double[] ix = this.imx(this.i);
        double[] dx = this.dmx(this.i);
        double[] mx_m1 = this.mmx(this.i - 1);
        double[] ix_m1 = this.imx(this.i - 1);
        double[] dx_m1 = this.dmx(this.i - 1);
        double[] tscMM = this.hmm.tsc(TSC.MM);
        double[] tscIM = this.hmm.tsc(TSC.IM);
        double[] tscDM = this.hmm.tsc(TSC.DM);
        double[] tscMI = this.hmm.tsc(TSC.MI);
        double[] tscII = this.hmm.tsc(TSC.II);
        double[] tscMD = this.hmm.tsc(TSC.MD);
        double[] tscDD = this.hmm.tsc(TSC.DD);
        if (this.startingState == 0) {
            System.err.println("It's really weird for the starting state to be zero...");
        }
        if (this.startingState > 0) {
            dx[this.startingState - 1] = Double.NEGATIVE_INFINITY;
            ix[this.startingState - 1] = Double.NEGATIVE_INFINITY;
            mx[this.startingState - 1] = Double.NEGATIVE_INFINITY;
        } else {
            dx[0] = Double.NEGATIVE_INFINITY;
            ix[0] = Double.NEGATIVE_INFINITY;
            mx[0] = Double.NEGATIVE_INFINITY;
        }
        for (int k = StrictMath.max(1, this.startingState); k < this.modelLength; ++k) {
            sc = StrictMath.max(mx_m1[k - 1] + tscMM[k - 1], ix_m1[k - 1] + tscIM[k - 1]);
            sc = StrictMath.max(sc, dx_m1[k - 1] + tscDM[k - 1]);
            mx[k] = sc + this.hmm.msc(k, b);
            sc = StrictMath.max(mx_m1[k] + tscMI[k], ix_m1[k] + tscII[k]);
            ix[k] = sc + this.hmm.isc(k, b);
            dx[k] = StrictMath.max(mx[k - 1] + tscMD[k - 1], dx[k - 1] + tscDD[k - 1]);
            lastMaxScore = StrictMath.max(StrictMath.max(mx[k], dx[k]), lastMaxScore);
        }
        sc = StrictMath.max(mx_m1[this.modelStates] + tscMM[this.modelStates], ix_m1[this.modelStates] + tscIM[this.modelStates]);
        sc = StrictMath.max(sc, dx_m1[this.modelStates] + tscDM[this.modelStates]);
        mx[this.modelLength] = sc + this.hmm.msc(this.modelLength, b);
        ix[this.modelLength] = Double.NEGATIVE_INFINITY;
        dx[this.modelLength] = StrictMath.max(this.mmx(this.i, this.modelStates) + tscMD[this.modelStates], dx[this.modelStates] + tscDD[this.modelStates]);
        lastMaxScore = StrictMath.max(StrictMath.max(mx[this.modelStates], dx[this.modelStates]), lastMaxScore);
        this.maxScores.add(lastMaxScore);
        sc = StrictMath.max(this.xmx(this.i, XSTATES.E), this.mmx(this.i, this.hmm.M()));
        this.xmx(this.i, XSTATES.E, StrictMath.max(sc, this.dmx(this.i, this.hmm.M())));
        sc = this.xmx(this.i - 1, XSTATES.J) + this.hmm.xsc(XSTATES.J, XSC.LOOP);
        this.xmx(this.i, XSTATES.J, StrictMath.max(sc, this.xmx(this.i, XSTATES.E) + this.hmm.xsc(XSTATES.E, XSC.LOOP)));
        sc = this.xmx(this.i - 1, XSTATES.C) + this.hmm.xsc(XSTATES.C, XSC.LOOP);
        this.xmx(this.i, XSTATES.C, StrictMath.max(sc, this.xmx(this.i, XSTATES.E) + this.hmm.xsc(XSTATES.E, XSC.MOVE)));
        this.xmx(this.i, XSTATES.N, this.xmx(this.i - 1, XSTATES.N) + this.hmm.xsc(XSTATES.N, XSC.LOOP));
        this.xmx(this.i, XSTATES.B, StrictMath.max(sc, this.xmx(this.i, XSTATES.J) + this.hmm.xsc(XSTATES.J, XSC.MOVE)));
    }
}

