/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastqCore
extends SeqReaderCore {
    public static final QualityFunction Phred33QualFunction = new QualityFunction(){

        public byte translate(char c) {
            return (byte)(c - 33);
        }

        public char translate(byte q) {
            return (char)((q <= 93 ? q : 93) + 33);
        }
    };
    private QualityFunction qualFunction;

    public FastqCore(File seqFile) throws IOException {
        super(seqFile);
        this.readUntilNext('@');
        this.qualFunction = Phred33QualFunction;
    }

    public FastqCore(InputStream seqFile) throws IOException {
        super(seqFile);
        this.readUntilNext('@');
        this.qualFunction = Phred33QualFunction;
    }

    @Override
    public Map<String, Long> scanInternal() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        this.readUntilNext('@');
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>();
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            seqIndex.put(sid, lastHeader);
            String temp = this.readUntilNext("\n@");
            String[] lines = temp.split("\n");
            if (lines.length == 2) {
                this.readUntilNext("\n@");
            }
            lastHeader = seqFile.getFilePointer();
        }
        seqFile.seek(firstHeader);
        return seqIndex;
    }

    public int scanToStream(DataOutputStream out) throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        this.readUntilNext('@');
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        out.writeLong(seqFile.length());
        out.writeUTF(SequenceFormat.FASTQ.toString());
        int written = 0;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            out.writeUTF(sid);
            out.writeLong(lastHeader);
            ++written;
            this.readUntilNext("\n@");
            lastHeader = seqFile.getFilePointer();
        }
        out.close();
        seqFile.seek(firstHeader);
        return written;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        String header = this.parseHeader();
        if (header == null) {
            return null;
        }
        String seqid = header.split("\\s+")[0];
        String seq = this.parseSeq();
        if (seq == null) {
            return null;
        }
        String qualHeader = this.parseHeader();
        if (qualHeader == null) {
            throw new IOException("Unexpected end of file when looking for qual seq for sequence " + seqid);
        }
        String qualId = qualHeader.split("\\s+")[0];
        if (!qualId.equals(seqid) && !qualId.equals("")) {
            throw new IOException("Expected quality sequence for " + seqid + " but found quality sequence for " + qualId);
        }
        byte[] qual = this.parseQualSeq();
        if (qual == null) {
            throw new IOException("Unexpected end of file when looking for qual seq for sequence " + seqid);
        }
        header = seqid.length() == header.length() ? "" : header.substring(seqid.length()).trim();
        return new QSequence(seqid, header, seq.trim(), qual);
    }

    private String parseSid() throws IOException {
        return this.readUntilNext(' ', '\t', '\n', '\r');
    }

    private String parseHeader() throws IOException {
        return this.readUntilNext('\n');
    }

    private String parseSeq() throws IOException {
        String str = this.readSeqString("\n+");
        return str;
    }

    private byte[] parseQualSeq() throws IOException {
        String str = this.readSeqString("\n@");
        if (str == null) {
            return null;
        }
        byte[] ret = new byte[str.length()];
        char[] seqChars = str.toCharArray();
        for (int index = 0; index < seqChars.length; ++index) {
            ret[index] = this.qualFunction.translate(seqChars[index]);
        }
        return ret;
    }

    public static interface QualityFunction {
        public byte translate(char var1);

        public char translate(byte var1);
    }
}

