/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFFCore
extends SeqReaderCore {
    public static final int mftMagicNumber = 778921588;
    public static final int srtMagicNumber = 779317876;
    public static final int v1MagicNumber = 825110576;
    protected CommonHeader commonHeader;
    private String manifest;
    private static final int READ_BLOCK_STATIC_SIZE = 16;
    private static final int COMMON_HEADER_STATIC_SIZE = 31;

    public SFFCore(File f) throws IOException {
        super(f);
        this.parseCommonHeader();
    }

    public SFFCore(InputStream is) throws IOException {
        super(is);
        this.parseCommonHeader();
    }

    private void parseCommonHeader() throws IOException {
        if (this.commonHeader != null) {
            throw new IOException("Common header already initialized");
        }
        this.commonHeader = new CommonHeader();
        DataInput seqFile = super.getDataInput();
        this.commonHeader.magicNumber = seqFile.readInt();
        if (this.commonHeader.magicNumber != 779314790) {
            throw new IOException("Not an SFF File");
        }
        this.commonHeader.version = seqFile.readInt();
        if (this.commonHeader.version != 1) {
            throw new IOException("Cannot parse v" + this.commonHeader.version + " sff files");
        }
        this.commonHeader.indexOffset = seqFile.readLong();
        this.commonHeader.indexLength = seqFile.readInt();
        this.commonHeader.numReads = seqFile.readInt();
        this.commonHeader.headerLength = seqFile.readShort();
        this.commonHeader.keyLength = seqFile.readShort();
        this.commonHeader.flowLength = seqFile.readShort();
        this.commonHeader.flowgramFormat = seqFile.readByte();
        byte[] flow = new byte[this.commonHeader.flowLength];
        super.read(flow);
        this.commonHeader.flow = new String(flow);
        byte[] key = new byte[this.commonHeader.keyLength];
        super.read(key);
        this.commonHeader.key = new String(key);
        int readBytes = 31 + flow.length + key.length;
        this.alignToBoundary(readBytes);
        if (super.isSeekable() && this.commonHeader.indexOffset > (long)this.commonHeader.headerLength) {
            this.readIndex();
        }
    }

    public CommonHeader getCommonHeader() {
        return this.commonHeader;
    }

    public String getManifest() {
        return this.manifest;
    }

    public LinkedHashMap<String, Long> scanInternal() throws IOException {
        if (this.commonHeader.indexOffset > (long)this.commonHeader.headerLength) {
            return this.readIndex();
        }
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(this.commonHeader.headerLength);
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>(this.commonHeader.numReads);
        for (int index = 0; index < this.commonHeader.numReads; ++index) {
            long pos = seqFile.getFilePointer();
            ReadBlock block = this.readReadBlock();
            seqIndex.put(block.name, pos);
        }
        return seqIndex;
    }

    @Override
    public QSequence readNextSeq() throws IOException {
        ReadBlock readBlock = this.readReadBlock();
        if (readBlock == null) {
            return null;
        }
        int clipLeft = Math.max(readBlock.clipAdapterLeft, readBlock.clipQualLeft);
        int clipRight = readBlock.numBases;
        if (readBlock.clipAdapterRight != 0 && readBlock.clipAdapterRight < clipRight) {
            clipRight = readBlock.clipAdapterRight;
        }
        if (readBlock.clipQualRight != 0 && readBlock.clipQualRight < clipRight) {
            clipRight = readBlock.clipQualRight;
        }
        String seq = readBlock.seq.substring(clipLeft - 1, clipRight);
        return new QSequence(readBlock.name, "", seq, Arrays.copyOfRange(readBlock.qual, clipLeft - 1, clipRight));
    }

    public ReadBlock readReadBlock() throws IOException {
        try {
            DataInput seqFile = super.getDataInput();
            ReadBlock ret = new ReadBlock();
            ret.headerLength = seqFile.readShort();
            ret.nameLength = seqFile.readShort();
            int tmp = ret.headerLength << 16 | ret.nameLength;
            if (tmp == 778921588) {
                return null;
            }
            ret.numBases = seqFile.readInt();
            ret.clipQualLeft = seqFile.readShort();
            ret.clipQualRight = seqFile.readShort();
            ret.clipAdapterLeft = seqFile.readShort();
            ret.clipAdapterRight = seqFile.readShort();
            byte[] readName = new byte[ret.nameLength];
            super.read(readName);
            int dataOffset = ret.headerLength - (ret.nameLength + 16);
            if (dataOffset < 0) {
                throw new IOException("Illegal ReadBlock header length (" + ret.headerLength + "), it would have me seek back in to the readblock");
            }
            seqFile.skipBytes(dataOffset);
            byte[] flowgramIndex = new byte[ret.numBases];
            byte[] bases = new byte[ret.numBases];
            byte[] quality = new byte[ret.numBases];
            byte[] homopolymerStretchEstimates = new byte[this.commonHeader.flowLength * 2];
            super.read(homopolymerStretchEstimates);
            super.read(flowgramIndex);
            super.read(bases);
            super.read(quality);
            DataInputStream flowgramStream = new DataInputStream(new ByteArrayInputStream(homopolymerStretchEstimates));
            short[] flowgrams = new short[this.commonHeader.flowLength];
            for (int index = 0; index < this.commonHeader.flowLength; ++index) {
                flowgrams[index] = flowgramStream.readShort();
            }
            flowgramStream.close();
            ret.name = new String(readName);
            ReadBlock.access$2102(ret, flowgrams);
            ReadBlock.access$2202(ret, flowgramIndex);
            ret.seq = new String(bases);
            ReadBlock.access$1802(ret, quality);
            int bytesRead = homopolymerStretchEstimates.length + flowgramIndex.length + bases.length + quality.length;
            this.alignToBoundary(bytesRead);
            return ret;
        }
        catch (EOFException e) {
            return null;
        }
    }

    private LinkedHashMap<String, Long> readIndex() throws IOException {
        int version;
        if (this.commonHeader.indexOffset <= (long)this.commonHeader.headerLength) {
            throw new IOException("Index offset is not set correctly");
        }
        RandomAccessFile seqFile = super.getRawFile();
        long seekBackTo = seqFile.getFilePointer();
        seqFile.seek(this.commonHeader.indexOffset);
        long dataEnd = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>(this.commonHeader.numReads);
        int magicNumber = seqFile.readInt();
        if (magicNumber == 778921588) {
            version = seqFile.readInt();
            if (version != 825110576) {
                throw new IOException("Can only parse .mft v1.0 indices");
            }
            int xmlSize = seqFile.readInt();
            int dataSize = seqFile.readInt();
            dataEnd += (long)dataSize;
            byte[] xml = new byte[xmlSize];
            seqFile.read(xml);
            this.manifest = new String(xml);
        } else if (magicNumber == 779317876) {
            version = seqFile.readInt();
            if (version != 825110576) {
                throw new IOException("Can only parse .srt v1.0 indices");
            }
            if (seqFile.read() != 0) {
                throw new IOException("Failed to find expected null byte in .srt header");
            }
            dataEnd += (long)this.commonHeader.indexLength;
        } else {
            throw new IOException("No supported index found");
        }
        ArrayList<Integer> currIndex = new ArrayList<Integer>();
        while (seqFile.getFilePointer() < dataEnd) {
            int b = seqFile.readUnsignedByte();
            if (b == 255) {
                byte[] nameArray = new byte[currIndex.size() - 5];
                long indexLoc = 0L;
                int[] multipliers = new int[]{0, 16581375, 65025, 255, 1};
                for (int i = 0; i < currIndex.size(); ++i) {
                    if (i < nameArray.length) {
                        nameArray[i] = (byte)((Integer)currIndex.get(i) & 0xFF);
                        continue;
                    }
                    int index = i - nameArray.length;
                    indexLoc += (long)((Integer)currIndex.get(i) * multipliers[index]);
                }
                String name = new String(nameArray);
                seqIndex.put(name, indexLoc);
                currIndex.clear();
                continue;
            }
            currIndex.add(b);
        }
        seqFile.seek(seekBackTo);
        return seqIndex;
    }

    private void alignToBoundary(int bytesRead) throws IOException {
        int pos = bytesRead % 8;
        if (pos != 0) {
            pos = 8 - pos % 8;
        }
        super.getDataInput().skipBytes(pos);
    }

    public static void main(String[] args) throws Exception {
        int index;
        SFFCore core = new SFFCore(new File("test/454Reads.sff"));
        System.out.println("Common header:");
        System.out.println(StringUtils.rightPad((String)"  Version:", (int)20) + core.commonHeader.version);
        System.out.println(StringUtils.rightPad((String)"  Index offset:", (int)20) + core.commonHeader.indexOffset);
        System.out.println(StringUtils.rightPad((String)"  Index length:", (int)20) + core.commonHeader.indexLength);
        System.out.println(StringUtils.rightPad((String)"  Num reads:", (int)20) + core.commonHeader.numReads);
        System.out.println(StringUtils.rightPad((String)"  Header length:", (int)20) + core.commonHeader.headerLength);
        System.out.println(StringUtils.rightPad((String)"  Key length:", (int)20) + core.commonHeader.keyLength);
        System.out.println(StringUtils.rightPad((String)"  Num flows:", (int)20) + core.commonHeader.flowLength);
        System.out.println(StringUtils.rightPad((String)"  Flowgram format:", (int)20) + core.commonHeader.flowgramFormat);
        System.out.println(StringUtils.rightPad((String)"  Flow:", (int)20) + core.commonHeader.flow);
        System.out.println(StringUtils.rightPad((String)"  Key:", (int)20) + core.commonHeader.key);
        System.out.println();
        ReadBlock block = core.readReadBlock();
        System.out.println(">" + block.name);
        System.out.println(StringUtils.rightPad((String)"  Name:", (int)20) + block.name);
        System.out.println(StringUtils.rightPad((String)"  Name length:", (int)20) + block.nameLength);
        System.out.println(StringUtils.rightPad((String)"  Number of bases:", (int)20) + block.numBases);
        System.out.println(StringUtils.rightPad((String)"  Length:", (int)20) + block.headerLength);
        System.out.println(StringUtils.rightPad((String)"  Clip adapter left:", (int)20) + block.clipAdapterLeft);
        System.out.println(StringUtils.rightPad((String)"  Clip adapter right:", (int)20) + block.clipAdapterRight);
        System.out.println(StringUtils.rightPad((String)"  Clip qual left:", (int)20) + block.clipQualLeft);
        System.out.println(StringUtils.rightPad((String)"  Clip qual right:", (int)20) + block.clipQualRight);
        System.out.print(StringUtils.rightPad((String)"Flowgrams:", (int)20));
        for (index = 0; index < block.flowgrams.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.flowgrams[index] + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Flow Indices:", (int)20));
        for (index = 0; index < block.flowIndex.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.flowIndex[index] + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Sequence:", (int)20));
        for (index = 0; index < block.seq.length(); ++index) {
            System.out.print(StringUtils.rightPad((String)(block.seq.charAt(index) + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Quality:", (int)20));
        for (index = 0; index < block.qual.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.qual[index] + ""), (int)10));
        }
        System.out.println();
        System.out.println();
        block = core.readReadBlock();
        System.out.println(">" + block.name);
        System.out.println(StringUtils.rightPad((String)"  Name:", (int)20) + block.name);
        System.out.println(StringUtils.rightPad((String)"  Name length:", (int)20) + block.nameLength);
        System.out.println(StringUtils.rightPad((String)"  Number of bases:", (int)20) + block.numBases);
        System.out.println(StringUtils.rightPad((String)"  Length:", (int)20) + block.headerLength);
        System.out.println(StringUtils.rightPad((String)"  Clip adapter left:", (int)20) + block.clipAdapterLeft);
        System.out.println(StringUtils.rightPad((String)"  Clip adapter right:", (int)20) + block.clipAdapterRight);
        System.out.println(StringUtils.rightPad((String)"  Clip qual left:", (int)20) + block.clipQualLeft);
        System.out.println(StringUtils.rightPad((String)"  Clip qual right:", (int)20) + block.clipQualRight);
        System.out.print(StringUtils.rightPad((String)"Flowgrams:", (int)20));
        for (index = 0; index < block.flowgrams.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.flowgrams[index] + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Flow Indices:", (int)20));
        for (index = 0; index < block.flowIndex.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.flowIndex[index] + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Sequence:", (int)20));
        for (index = 0; index < block.seq.length(); ++index) {
            System.out.print(StringUtils.rightPad((String)(block.seq.charAt(index) + ""), (int)10));
        }
        System.out.println();
        System.out.print(StringUtils.rightPad((String)"Quality:", (int)20));
        for (index = 0; index < block.qual.length; ++index) {
            System.out.print(StringUtils.rightPad((String)(block.qual[index] + ""), (int)10));
        }
        System.out.println();
        core.close();
    }

    public static class ReadBlock {
        private int headerLength;
        private int nameLength;
        private String name;
        private int numBases;
        private int clipQualLeft;
        private int clipQualRight;
        private int clipAdapterLeft;
        private int clipAdapterRight;
        private String seq;
        private short[] flowgrams;
        private byte[] flowIndex;
        private byte[] qual;

        public int getClipAdapterLeft() {
            return this.clipAdapterLeft;
        }

        public int getClipAdapterRight() {
            return this.clipAdapterRight;
        }

        public int getClipQualLeft() {
            return this.clipQualLeft;
        }

        public int getClipQualRight() {
            return this.clipQualRight;
        }

        public byte[] getFlowIndex() {
            return this.flowIndex;
        }

        public int getHeaderLength() {
            return this.headerLength;
        }

        public short[] getFlowgrams() {
            return this.flowgrams;
        }

        public String getName() {
            return this.name;
        }

        public int getNameLength() {
            return this.nameLength;
        }

        public int getNumBases() {
            return this.numBases;
        }

        public byte[] getQual() {
            return this.qual;
        }

        public String getSeq() {
            return this.seq;
        }

        static /* synthetic */ short[] access$2102(ReadBlock x0, short[] x1) {
            x0.flowgrams = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$2202(ReadBlock x0, byte[] x1) {
            x0.flowIndex = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$1802(ReadBlock x0, byte[] x1) {
            x0.qual = x1;
            return x1;
        }
    }

    public static class CommonHeader {
        private int magicNumber;
        private int version;
        private long indexOffset;
        private int indexLength;
        private int numReads;
        private short headerLength;
        private short keyLength;
        private short flowLength;
        private byte flowgramFormat;
        private String flow;
        private String key;

        public String getFlow() {
            return this.flow;
        }

        public short getFlowLength() {
            return this.flowLength;
        }

        public byte getFlowgramFormat() {
            return this.flowgramFormat;
        }

        public short getHeaderLength() {
            return this.headerLength;
        }

        public int getIndexLength() {
            return this.indexLength;
        }

        public long getIndexOffset() {
            return this.indexOffset;
        }

        public String getKey() {
            return this.key;
        }

        public short getKeyLength() {
            return this.keyLength;
        }

        public int getMagicNumber() {
            return this.magicNumber;
        }

        public int getNumReads() {
            return this.numReads;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

