/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.IndexedSeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.utils.BarcodeUtils;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import edu.msu.cme.rdp.readseq.writers.FastqWriter;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeSorter {
    public static final String NoTag = "NoTag";

    private static File getFastaFile(File workDir, String tag, String suffix) throws IOException {
        return new File(workDir, tag + suffix);
    }

    public static Map<String, List<File>> sort(File seqFile, File tagFile) throws IOException, BarcodeUtils.BarcodeInvalidException {
        return BarcodeSorter.sortWithQual(seqFile, null, tagFile, new File("."));
    }

    public static Map<String, List<File>> sort(File seqFile, File tagFile, File workDir) throws IOException, BarcodeUtils.BarcodeInvalidException {
        return BarcodeSorter.sortWithQual(seqFile, null, tagFile, workDir);
    }

    public static Map<String, List<File>> sortWithQual(File seqFile, File qualFile, File tagFile) throws IOException, BarcodeUtils.BarcodeInvalidException {
        return BarcodeSorter.sortWithQual(seqFile, qualFile, tagFile, new File("."));
    }

    public static Map<String, List<File>> sortWithQual(File seqFile, File qualFile, File tagFile, File workDir) throws IOException, BarcodeUtils.BarcodeInvalidException {
        Sequence seq;
        SequenceFormat format = SeqUtils.guessFileFormat(seqFile);
        if (format != SequenceFormat.FASTA && qualFile != null && qualFile.exists()) {
            throw new IOException("Cannot provide an external quality file with non-fasta files");
        }
        boolean hasQuality = qualFile != null && qualFile.exists() || format == SequenceFormat.FASTQ || format == SequenceFormat.SFF;
        HashMap<String, List<File>> ret = new HashMap<String, List<File>>();
        SequenceReader seqReader = new SequenceReader(seqFile);
        IndexedSeqReader qualReader = null;
        if (qualFile != null && qualFile.exists()) {
            qualReader = new IndexedSeqReader(qualFile, true, false);
        }
        HashMap<String, SequenceWriter> tagToStream = new HashMap<String, SequenceWriter>();
        HashMap<File, SequenceWriter> fileNameToStream = new HashMap<File, SequenceWriter>();
        Map<String, String> barcodeMap = BarcodeUtils.readBarcodeFile(tagFile);
        barcodeMap.put(NoTag, NoTag);
        for (String barcode : barcodeMap.keySet()) {
            File fileName = null;
            SequenceWriter stream = null;
            String tagName = barcodeMap.get(barcode);
            fileName = hasQuality ? BarcodeSorter.getFastaFile(workDir, tagName, ".fastq") : BarcodeSorter.getFastaFile(workDir, tagName, ".fasta");
            stream = (SequenceWriter)fileNameToStream.get(fileName);
            if (stream == null) {
                if (!ret.keySet().contains(tagName)) {
                    ret.put(tagName, new ArrayList());
                }
                ((List)ret.get(tagName)).add(fileName);
                stream = hasQuality ? new FastqWriter(fileName, FastqCore.Phred33QualFunction) : new FastaWriter(fileName);
                fileNameToStream.put(fileName, stream);
            }
            tagToStream.put(barcode, stream);
        }
        while ((seq = BarcodeSorter.readNextSequence(seqReader, qualReader)) != null) {
            boolean tagMatched = false;
            for (String barcode : tagToStream.keySet()) {
                if (seq.getSeqString().toLowerCase().indexOf(barcode) != 0) continue;
                ((SequenceWriter)tagToStream.get(barcode)).writeSeq(seq);
                tagMatched = true;
                break;
            }
            if (tagMatched) continue;
            ((SequenceWriter)tagToStream.get(NoTag)).writeSeq(seq);
        }
        seqReader.close();
        if (qualReader != null) {
            qualReader.close();
        }
        for (String tag : tagToStream.keySet()) {
            ((SequenceWriter)tagToStream.get(tag)).close();
        }
        for (String barcode : barcodeMap.keySet()) {
            String tag = barcodeMap.get(barcode);
            File f = BarcodeSorter.getFastaFile(workDir, tag, ".fasta");
            File parent = f.getParentFile();
            File q = BarcodeSorter.getFastaFile(workDir, tag, ".fastq");
            if (f.exists() && f.length() == 0L) {
                f.delete();
                if (q != null && q.exists() && q.length() == 0L) {
                    q.delete();
                }
            }
            if (q != null && q.exists() && q.length() == 0L) {
                q.delete();
            }
            if (parent.listFiles().length != 0) continue;
            parent.delete();
        }
        return ret;
    }

    public static Map<String, List<File>> sort(List<File> seqFiles, File tagFile, File workDir, byte defaultQual) throws IOException, BarcodeUtils.BarcodeInvalidException {
        boolean hasQuality = false;
        for (File f : seqFiles) {
            SequenceFormat format = SeqUtils.guessFileFormat(f);
            if (format != SequenceFormat.FASTQ && format != SequenceFormat.SFF) continue;
            hasQuality = true;
            break;
        }
        HashMap<String, List<File>> ret = new HashMap<String, List<File>>();
        HashMap<String, SequenceWriter> tagToStream = new HashMap<String, SequenceWriter>();
        HashMap<File, SequenceWriter> fileNameToStream = new HashMap<File, SequenceWriter>();
        Map<String, String> barcodeMap = BarcodeUtils.readBarcodeFile(tagFile);
        barcodeMap.put(NoTag, NoTag);
        for (String barcode : barcodeMap.keySet()) {
            String tagName = barcodeMap.get(barcode);
            File fileName = hasQuality ? BarcodeSorter.getFastaFile(workDir, tagName, ".fastq") : BarcodeSorter.getFastaFile(workDir, tagName, ".fasta");
            SequenceWriter stream = (SequenceWriter)fileNameToStream.get(fileName);
            if (stream == null) {
                if (!ret.keySet().contains(tagName)) {
                    ret.put(tagName, new ArrayList());
                }
                ((List)ret.get(tagName)).add(fileName);
                stream = hasQuality ? new FastqWriter(fileName, FastqCore.Phred33QualFunction, defaultQual) : new FastaWriter(fileName);
                fileNameToStream.put(fileName, stream);
            }
            tagToStream.put(barcode, stream);
        }
        for (File seqFile : seqFiles) {
            Object seq;
            SequenceReader seqReader = new SequenceReader(seqFile);
            while ((seq = seqReader.readNextSequence()) != null) {
                boolean tagMatched = false;
                for (String barcode : tagToStream.keySet()) {
                    if (((Sequence)seq).getSeqString().toLowerCase().indexOf(barcode) != 0) continue;
                    ((SequenceWriter)tagToStream.get(barcode)).writeSeq((Sequence)seq);
                    tagMatched = true;
                    break;
                }
                if (tagMatched) continue;
                ((SequenceWriter)tagToStream.get(NoTag)).writeSeq((Sequence)seq);
            }
            seqReader.close();
        }
        for (String tag : tagToStream.keySet()) {
            ((SequenceWriter)tagToStream.get(tag)).close();
        }
        for (String tag : ret.keySet()) {
            List files = (List)ret.get(tag);
            HashSet<File> remove = new HashSet<File>();
            for (File f : files) {
                if (!f.exists() || f.length() != 0L) continue;
                f.delete();
                remove.add(f);
            }
            files.removeAll(remove);
        }
        return ret;
    }

    private static Sequence readNextSequence(SequenceReader seqReader, IndexedSeqReader qualReader) throws IOException {
        Sequence ret = null;
        if (qualReader != null) {
            Sequence next = seqReader.readNextSequence();
            if (next != null) {
                Sequence qualSeq = qualReader.readSeq(next.getSeqName());
                String[] tokens = qualSeq.getSeqString().split("\\s+");
                byte[] qual = new byte[tokens.length];
                try {
                    for (int index = 0; index < tokens.length; ++index) {
                        qual[index] = Byte.parseByte(tokens[index]);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IOException("Invalid quality sequence for seq " + next.getSeqName());
                }
                ret = new QSequence(next.getSeqName(), next.getDesc(), next.getSeqString(), qual);
            }
        } else {
            ret = seqReader.readNextSequence();
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        BarcodeSorter.sortWithQual(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]));
    }
}

