/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.orientation;

import java.io.IOException;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.Random;

public class GoodWordIterator {
    private int curIndex = 0;
    private int numOfWords = 0;
    private int[] wordIndexArr;
    public static final int DEFAULT_WORDSIZE = 8;
    private static int WORDSIZE = 8;
    private static boolean wordsizeHasSet = false;
    public static final float PERCENT_SELECTION = 0.125f;
    private static int MASK = (1 << WORDSIZE * 2) - 1;
    static final int MAX_ASCII = 128;
    private static int[] charIntegerLookup = new int[128];

    public static void setWordSize(int w) {
        if (wordsizeHasSet) {
            throw new IllegalStateException("word size has been set, can not set again");
        }
        WORDSIZE = w;
        MASK = (1 << WORDSIZE * 2) - 1;
        wordsizeHasSet = true;
    }

    public GoodWordIterator(String seq) throws IOException {
        if (!wordsizeHasSet) {
            GoodWordIterator.setWordSize(WORDSIZE);
        }
        this.wordIndexArr = new int[seq.length()];
        this.createWordIndex(seq);
    }

    public GoodWordIterator(String seq, int wordsLimit) throws IOException {
        if (!wordsizeHasSet) {
            GoodWordIterator.setWordSize(WORDSIZE);
        }
        this.wordIndexArr = new int[seq.length()];
        this.createWordIndex(seq, wordsLimit);
    }

    public boolean hasNext() {
        return this.curIndex < this.numOfWords;
    }

    public int next() throws NoSuchElementException {
        if (this.hasNext()) {
            int tmp = this.curIndex++;
            return this.wordIndexArr[tmp];
        }
        throw new NoSuchElementException();
    }

    private void createWordIndex(String seq) throws IOException {
        int c;
        StringReader in = new StringReader(seq);
        int count = 0;
        int wordIndex = 0;
        int charIndex = 0;
        while ((c = in.read()) != -1) {
            charIndex = charIntegerLookup[c];
            if (charIndex == -1) {
                wordIndex = 0;
                count = 0;
                continue;
            }
            wordIndex <<= 2;
            wordIndex &= MASK;
            wordIndex |= charIndex;
            if (++count != WORDSIZE) continue;
            this.wordIndexArr[this.numOfWords] = wordIndex;
            ++this.numOfWords;
            --count;
        }
        in.close();
    }

    private void createWordIndex(String seq, int wordsLimit) throws IOException {
        int c;
        StringReader in = new StringReader(seq);
        int count = 0;
        int wordIndex = 0;
        int charIndex = 0;
        while ((c = in.read()) != -1 && this.numOfWords < wordsLimit) {
            charIndex = charIntegerLookup[c];
            if (charIndex == -1) {
                wordIndex = 0;
                count = 0;
                continue;
            }
            wordIndex <<= 2;
            wordIndex &= MASK;
            wordIndex |= charIndex;
            if (++count != WORDSIZE) continue;
            this.wordIndexArr[this.numOfWords] = wordIndex;
            ++this.numOfWords;
            --count;
        }
        in.close();
    }

    public static int getWordsize() {
        if (!wordsizeHasSet) {
            GoodWordIterator.setWordSize(WORDSIZE);
        }
        return WORDSIZE;
    }

    public static boolean isWordsizeHasSet() {
        return wordsizeHasSet;
    }

    public int getMask() {
        return MASK;
    }

    public int getNumofWords() {
        return this.numOfWords;
    }

    public void resetCurIndex() {
        this.curIndex = 0;
    }

    public static int getCharIndex(int c) {
        return charIntegerLookup[c];
    }

    public int[] getWordArr() {
        if (this.getNumofWords() == 0) {
            throw new IllegalStateException("Error: The sequence contains 0 valid words");
        }
        int[] wordList = new int[this.getNumofWords()];
        this.resetCurIndex();
        int num = 0;
        while (this.hasNext()) {
            wordList[num++] = this.next();
        }
        return wordList;
    }

    public static int[] getRdmWordArr(int[] wordList, int min_bootstrap_words, Random randomGenerator) {
        int numOfSelection = Math.max((int)((float)wordList.length * 0.125f), min_bootstrap_words);
        int[] testWordList = new int[numOfSelection];
        for (int i = 0; i < numOfSelection; ++i) {
            int randomIndex = randomGenerator.nextInt(wordList.length);
            testWordList[i] = wordList[randomIndex];
        }
        return testWordList;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            GoodWordIterator.charIntegerLookup[i] = -1;
        }
        GoodWordIterator.charIntegerLookup[65] = 0;
        GoodWordIterator.charIntegerLookup[85] = 1;
        GoodWordIterator.charIntegerLookup[84] = 1;
        GoodWordIterator.charIntegerLookup[71] = 2;
        GoodWordIterator.charIntegerLookup[67] = 3;
        GoodWordIterator.charIntegerLookup[97] = 0;
        GoodWordIterator.charIntegerLookup[117] = 1;
        GoodWordIterator.charIntegerLookup[116] = 1;
        GoodWordIterator.charIntegerLookup[103] = 2;
        GoodWordIterator.charIntegerLookup[99] = 3;
    }
}

