## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL ## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----scp_framework, results='markup', fig.cap="`scp` relies on `SingleCellExperiment` and `QFeatures` objects.", echo=FALSE, out.width='100%', fig.align='center'----
knitr::include_graphics("./figures/SCP_framework.png", error = FALSE)

## ---- message = FALSE---------------------------------------------------------
library(scp)
data("mqScpData")
dim(mqScpData)

## -----------------------------------------------------------------------------
(quantCols <- grep("Reporter.intensity.\\d", colnames(mqScpData),
                  value = TRUE))

## -----------------------------------------------------------------------------
head(mqScpData[, quantCols])

## -----------------------------------------------------------------------------
head(mqScpData[, c("Charge", "Score", "PEP", "Sequence", "Length",
                   "Retention.time", "Proteins")])

## -----------------------------------------------------------------------------
unique(mqScpData$Raw.file)

## -----------------------------------------------------------------------------
data("sampleAnnotation")
head(sampleAnnotation)

## ---- fig.cap = "Linking the sample data to the feature data", echo = FALSE----
knitr::include_graphics("figures/readSCP_relation.png")

## ----readSCP------------------------------------------------------------------
scp <- readSCP(featureData = mqScpData,
               colData = sampleAnnotation,
               batchCol = "Raw.file",
               channelCol = "Channel",
               suffix = paste0("_TMT", 1:16),
               removeEmptyCols = TRUE)

## ----overview-----------------------------------------------------------------
scp

## ----colData------------------------------------------------------------------
head(colData(scp))

## ----rowData------------------------------------------------------------------
head(rowData(scp[["190222S_LCA9_X_FP94BM"]]))[, 1:5]

## ----assay--------------------------------------------------------------------
head(assay(scp, "190222S_LCA9_X_FP94BM"))

## ----setup2, include = FALSE--------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "",
    crop = NULL
)

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

