## ----echo=FALSE, message=FALSE------------------------------------------------
options(rmarkdown.html_vignette.check_title = FALSE)
library(sesame)
sesameDataCacheAll()

## -----------------------------------------------------------------------------
sdf <- sesameDataGet('EPIC.1.SigDF')
as.data.frame(qualityRank(sdf))

## ----message = FALSE----------------------------------------------------------
sdfs = sesameDataGet("EPIC.5.SigDF.normal")

## -----------------------------------------------------------------------------
sesameQC(sdfs[[1]])

## -----------------------------------------------------------------------------
qc5 <- do.call(rbind, lapply(sdfs, function(x)
    as.data.frame(sesameQC(x))))
qc5$sample_name <- names(sdfs)

qc5[,c('mean_beta_cg','frac_meth_cg','frac_unmeth_cg')]

## -----------------------------------------------------------------------------
library(ggplot2)
ggplot(qc5,
    aes(x = mean_oob_grn, y= mean_oob_red, label = sample_name)) +
    geom_point() + geom_text(hjust = -0.1, vjust = 0.1) +
    geom_abline(intercept = 0, slope = 1, linetype = 'dotted') +
    xlab('Green Background') + ylab('Red Background') +
    xlim(c(200,600)) + ylim(c(200,600))

## ----warning = FALSE----------------------------------------------------------
library(wheatmap)
p1 <- ggplot(qc5) +
    geom_bar(aes(sample_name, mean_intensity), stat='identity') +
    xlab('Sample Name') + ylab('Mean Intensity') +
    ylim(0,18000) +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
p2 <- ggplot(qc5) +
    geom_bar(aes(sample_name, mean_intensity_total), stat='identity') +
    xlab('Sample Name') + ylab('Mean M+U Intensity') +
    ylim(0,18000) +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
WGG(p1) + WGG(p2, RightOf())

## -----------------------------------------------------------------------------
p1 <- ggplot(qc5) +
    geom_bar(aes(sample_name, num_na_cg), stat='identity') +
    xlab('Sample Name') + ylab('Number of NAs') +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
p2 <- ggplot(qc5) +
    geom_bar(aes(sample_name, frac_na_cg), stat='identity') +
    xlab('Sample Name') + ylab('Fraction of NAs (%)') +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
WGG(p1) + WGG(p2, RightOf())

## -----------------------------------------------------------------------------
ggplot(qc5) +
    geom_point(aes(InfI_switch_G2R, InfI_switch_R2G))

## -----------------------------------------------------------------------------
sdf <- sesameDataGet('EPIC.1.SigDF')
bisConversionControl(sdf)

## -----------------------------------------------------------------------------
annoS = sesameDataGetAnno("EPIC/EPIC.hg19.snp_overlap_b151.rds")
annoI = sesameDataGetAnno("EPIC/EPIC.hg19.typeI_overlap_b151.rds")
head(formatVCF(sdf, annoS=annoS, annoI=annoI))

## -----------------------------------------------------------------------------
sessionInfo()

