## ----echo=FALSE, message=FALSE------------------------------------------------
library(sesame)
sesameDataCacheAll()

## -----------------------------------------------------------------------------
sdf = sesameDataGet('EPIC.1.SigDF')
inferSex(sdf)
inferSexKaryotypes(sdf)

## -----------------------------------------------------------------------------
inferEthnicity(sdf)

## -----------------------------------------------------------------------------
betas <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
predictAgeHorvath353(betas)

## -----------------------------------------------------------------------------
meanIntensity(sdf)

## ---- message=FALSE, fig.width=6----------------------------------------------
sdfs.normal <- sesameDataGet('EPIC.5.SigDF.normal')
segs <- cnSegmentation(sdf, sdfs.normal)

## ---- message=FALSE, fig.width=6----------------------------------------------
visualizeSegments(segs)

## ---- message=FALSE-----------------------------------------------------------
betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
estimateLeukocyte(betas.tissue)

## -----------------------------------------------------------------------------
sessionInfo()

