## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)
library(wheatmap)
library(dplyr)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----echo=FALSE, message=FALSE------------------------------------------------
sesameDataCache("MM285")

## ----eval=FALSE---------------------------------------------------------------
#  res_grn = sesameDataDownload("204637490002_R05C01_Grn.idat")
#  res_red = sesameDataDownload("204637490002_R05C01_Red.idat")
#  pfx = sprintf("%s/204637490002_R05C01", res_red$dest_dir)

## ----eval=FALSE---------------------------------------------------------------
#  sdf = readIDATpair(pfx)

## ----eval=FALSE---------------------------------------------------------------
#  openSesame(idat_dir)

## ----include=FALSE------------------------------------------------------------
sdf = sesameDataGet('MM285.1.SigDF')

## -----------------------------------------------------------------------------
sdf_normalized = sdf %>%
                 qualityMask %>%
                 pOOBAH %>%
                 noob %>%
                 dyeBiasCorrTypeINorm

## -----------------------------------------------------------------------------
betas = getBetas(sdf_normalized)

## -----------------------------------------------------------------------------
sum(is.na(betas))
head(betas[grep('uk', names(betas))])

## -----------------------------------------------------------------------------
betas = sdf_normalized %>%
        setMask(pOOBAH(qualityMask(sdf), return.pval=TRUE)>0.05) %>%
        getBetas
sum(is.na(betas))
head(betas[grep('uk', names(betas))])

## -----------------------------------------------------------------------------
betas = getBetas(sdf_normalized, mask = FALSE)
sum(is.na(betas))

## -----------------------------------------------------------------------------
betas = getBetas(resetMask(sdf_normalized))
sum(is.na(betas))

## ----message=FALSE------------------------------------------------------------
betas = sesameDataGet("MM285.10.tissue")$betas
visualizeGene("Igf2", betas = betas, platform="MM285", refversion = "mm10")

## -----------------------------------------------------------------------------
sdf <- sesameDataGet("MM285.1.SigDF")

## -----------------------------------------------------------------------------
inferSpecies(sdf)$species

## -----------------------------------------------------------------------------
betas <- sdf %>%
         noob %>%
         dyeBiasCorrTypeINorm %>%
         getBetas

## -----------------------------------------------------------------------------
strain <- inferStrain(betas)
strain$pval

## -----------------------------------------------------------------------------
library(ggplot2)
df <- data.frame(strain=names(strain$probs), probs=strain$probs)
ggplot(data = df,  aes(x = strain, y = log(probs))) +
  geom_bar(stat = "identity", color="gray") +
  ggtitle("strain probabilities") +
  scale_x_discrete(position = "top") +
  theme(axis.text.x = element_text(angle = 90), legend.position = "none")

## -----------------------------------------------------------------------------
betas <- sesameDataGet("MM285.10.tissue")$betas[,1:2]

## -----------------------------------------------------------------------------
options(sesameData_use_alternative=TRUE)
compareMouseTissueReference(betas)

## -----------------------------------------------------------------------------
sdf = sesameDataGet("MM285.1.SigDF")

## -----------------------------------------------------------------------------
inferSex(sdf)

## -----------------------------------------------------------------------------
betas <- sesameDataGet('MM285.10.tissue')$betas

## -----------------------------------------------------------------------------
predictMouseAgeInMonth(betas[,1])

## ----echo=FALSE, message=FALSE------------------------------------------------
sesameDataCache("Mammal40")

## -----------------------------------------------------------------------------
res_grn = sesameDataDownload("GSM4411982_Grn.idat.gz")
res_red = sesameDataDownload("GSM4411982_Red.idat.gz")
sdf = readIDATpair(sprintf("%s/GSM4411982", res_red$dest_dir))

## -----------------------------------------------------------------------------
sdf_normalized = dyeBiasCorrTypeINorm(noob(pOOBAH(qualityMask(sdf))))

## -----------------------------------------------------------------------------
betas = getBetas(sdf_normalized)
head(betas)

## -----------------------------------------------------------------------------
sessionInfo()

