## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)
sesameDataCacheAll()
library(dplyr)
options(rmarkdown.html_vignette.check_title = FALSE)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("sesame")

## ---- eval=FALSE--------------------------------------------------------------
#  BiocManager::install('zwdzwd/sesameData')
#  BiocManager::install('zwdzwd/sesame')

## ----eval=FALSE---------------------------------------------------------------
#  sesameDataCacheAll()

## ----eval=FALSE---------------------------------------------------------------
#  sesameDataCache("EPIC")

## -----------------------------------------------------------------------------
tools::R_user_dir("ExperimentHub", which="cache")

## ----eval=FALSE---------------------------------------------------------------
#  sdf = readIDAT("204529320035_R06C01")  # Example 1
#  sdf = readIDAT("GSM2178224")           # Example 2

## ----echo=FALSE---------------------------------------------------------------
sdf = sesameDataGet('EPIC.1.SigDF')

## ----eval=FALSE---------------------------------------------------------------
#  sdf = readIDAT("GSM2178224")

## -----------------------------------------------------------------------------
print(sdf)
head(as.data.frame(sdf)) # peek into the internals
betas = getBetas(sdf)
head(betas)

## -----------------------------------------------------------------------------
sdfs = lapply(
    searchIDATprefixes(system.file("extdata/", package = "sesameData")),
    readIDATpair)
sdfs

## -----------------------------------------------------------------------------
mft = sesameDataGet("MM285.address")$ordering

## -----------------------------------------------------------------------------
head(mft[!is.na(mft$col),])

## ----eval = FALSE-------------------------------------------------------------
#  sdf = readIDATpair("your_sample_name", manifest = mft)
#  betas = getBetas(sdf)

## -----------------------------------------------------------------------------
library(sesame)
## show case using an example without mask, then add mask with qualityMask
sdf = qualityMask(sesameDataGet('EPIC.1.SigDF'))
betas = getBetas(sdf, sum.TypeI = TRUE)

## -----------------------------------------------------------------------------
extraSNPAFs = getAFTypeIbySumAlleles(sdf)

## ----message = FALSE----------------------------------------------------------
betas = getBetas(sdf)
head(betas)

## -----------------------------------------------------------------------------
head(sdf$mask)
sum(sdf$mask)   # number of probes to be NA-masked
sum(is.na(betas)) # should be the same as above

## -----------------------------------------------------------------------------
sum(sdf$mask)  # before resetting
sum(resetMask(sdf)$mask)  # after resetting, expect 0

## -----------------------------------------------------------------------------
sum(is.na(getBetas(sdf, mask=FALSE)))  # expect 0

## -----------------------------------------------------------------------------
sum(sdf$mask)  # before pOOBAH
sum(pOOBAH(sdf)$mask) # after pOOBAH, expect more probes
sum(pOOBAH(resetMask(sdf))$mask) # pOOBAH-only masking

## -----------------------------------------------------------------------------
pvals = pOOBAH(sdf, return.pval=TRUE)
sdf2 = addMask(sdf, pvals > 0.05) # default, recommend between 0.05 and 0.2

## -----------------------------------------------------------------------------
sdf.nb = noob(sdf)          # noob background subtraction
sdf.sb = scrub(sdf)         # more aggressive background subtraction

## ----fig.width=5--------------------------------------------------------------
sesamePlotIntensVsBetas(sdf)
sesamePlotIntensVsBetas(sdf.nb) # with noob
sesamePlotIntensVsBetas(sdf.sb) # with scrub

## ----fig.width=5--------------------------------------------------------------
library(sesame)
sdf.dbLinear = dyeBiasCorr(sdf)
sesamePlotRedGrnQQ(sdf.dbLinear)

## -----------------------------------------------------------------------------
sdf.dbNonlinear = dyeBiasCorrTypeINorm(sdf)

## ----fig.width=5--------------------------------------------------------------
sesamePlotRedGrnQQ(sdf.dbNonlinear)

## -----------------------------------------------------------------------------
sdf.InfICorrected = inferInfiniumIChannel(sdf, verbose=TRUE)

## ----eval = FALSE-------------------------------------------------------------
#  idat_dir = system.file("extdata/", package = "sesameData")
#  betas = do.call(cbind, mclapply(searchIDATprefixes(idat_dir), function(pfx) {
#      getBetas(dyeBiasNL(noob(pOOBAH(readIDATpair(pfx)))))
#  }), mc.cores=2)

## ----eval = FALSE-------------------------------------------------------------
#  idat_dir = system.file("extdata/", package = "sesameData")
#  betas = openSesame(idat_dir)

## ----eval = FALSE-------------------------------------------------------------
#  betas = openSesame(idat_dir, BPPARAM=BiocParallel::MulticoreParam(2))

## ----eval = FALSE-------------------------------------------------------------
#  betas = openSesame(idat_dir, manifest = manifest)

## -----------------------------------------------------------------------------
colnames(sdf)

## -----------------------------------------------------------------------------
head(sdf[sdf$col != "2",])      # Infinium-I probes
head(sdf[sdf$col == "2",])      # Infinium-II probes

## -----------------------------------------------------------------------------
## same as head(attr(sdf, "controls"))
head(controls(sdf))  # the last column: the type of the control.

## -----------------------------------------------------------------------------
txt_file_path = sprintf("%s/sigdf.txt", tempdir())
sdf_write_table(sdf, file=txt_file_path) # save as space-delimited txt
sdf2 = sdf_read_table(txt_file_path)     # read back

tsv_file_path = sprintf("%s/sigdf.tsv", tempdir())
sdf_write_table(sdf, file=tsv_file_path, sep="\t", quote=FALSE) # save as tsv
sdf2 = sdf_read_table(tsv_file_path)                            # read back

csv_file_path = sprintf("%s/sigdf.csv", tempdir())
sdf_write_table(sdf, file=csv_file_path, sep=",") # save as csv
sdf2 = sdf_read_table(csv_file_path, sep=",")     # read back

## ----message = FALSE----------------------------------------------------------
library(sesame)
library(FlowSorted.Blood.450k)
options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
grSet <- sesamize(FlowSorted.Blood.450k[,1:4])
grSet

## -----------------------------------------------------------------------------
sessionInfo()

