## ----environment, echo=FALSE--------------------------------------------------
suppressPackageStartupMessages(library("synapter"))
suppressPackageStartupMessages(library("synapterdata"))
suppressPackageStartupMessages(library("BiocStyle"))
synobj2RData()

## ----create-synobj2-file, echo=FALSE, comment=NA------------------------------
cat(readLines(system.file(file.path("scripts", "create_synobj2.R"),
                          package="synapterdata"), n=13), sep="\n")

## ----show-synobj2-------------------------------------------------------------
synobj2

## ----filtering----------------------------------------------------------------
filterUniqueDbPeptides(synobj2,
                       missedCleavages=0,
                       IisL=TRUE)
filterPeptideLength(synobj2, l=7)
plotFdr(synobj2)
filterQuantPepScore(synobj2, method="BH",
                    fdr=0.05)
filterIdentPepScore(synobj2, method="BH",
                    fdr=0.05)
par(mfcol=c(1, 2))
plotPpmError(synobj2, what="Ident")
plotPpmError(synobj2, what="Quant")
par(mfcol=c(1, 1))
filterQuantPpmError(synobj2, ppm=20)
filterIdentPpmError(synobj2, ppm=20)
plotPepScores(synobj2)
filterIdentProtFpr(synobj2, fpr=0.05)
filterQuantProtFpr(synobj2, fpr=0.05)

## ----rtmodel------------------------------------------------------------------
mergePeptides(synobj2)

plotRt(synobj2, what="data")
setLowessSpan(synobj2, span=0.05)
modelRt(synobj2)

par(mfcol=c(1, 2))
plotRtDiffs(synobj2)
plotRt(synobj2, what="model", nsd=1)
par(mfcol=c(1, 1))

plotFeatures(synobj2, what="all", ionmobility=TRUE)

## ----gridsearch---------------------------------------------------------------
searchGrid(synobj2,
           imdiffs=seq(from=0.6, to=1.6, by=0.2),
           ppms=seq(from=2, to=20, by=2),
           nsds=seq(from=0.5, to=5, by=0.5))
setBestGridParams(synobj2)
findEMRTs(synobj2)
plotEMRTtable(synobj2)

## ----filterfragments----------------------------------------------------------
filterFragments(synobj2,
                what="fragments.ident",
                minIntensity=70)
filterFragments(synobj2,
                what="spectra.quant",
                minIntensity=70)

## ----fm-----------------------------------------------------------------------
fragmentMatching(synobj2)

## ----fmperf, results="asis"---------------------------------------------------
knitr::kable(fragmentMatchingPerformance(synobj2,
                                         what="unique"))
knitr::kable(fragmentMatchingPerformance(synobj2,
                                         what="non-unique"))

## ----filterfm-----------------------------------------------------------------
filterUniqueMatches(synobj2, minNumber=1)
filterNonUniqueMatches(synobj2, minDelta=2)
filterNonUniqueIdentMatches(synobj2)

## ----rescue-------------------------------------------------------------------
rescueEMRTs(synobj2, method="rescue")

## ----intmodel-----------------------------------------------------------------
plotIntensity(synobj2, what="data")
setLowessSpan(synobj2, 0.05)
modelIntensity(synobj2)
plotIntensity(synobj2, what="model", nsd=1)

## ----synergise2, eval=FALSE---------------------------------------------------
#  synobj2 <- synergise2(filenames = inlist,
#                        outputdir = ".")

## ----convert------------------------------------------------------------------
msn <- as(synobj2, "MSnSet")

## ----synapterplgs, results="asis"---------------------------------------------
msn <- synapterPlgsAgreement(msn)
knitr::kable(head(fData(msn)[, grepl("[Aa]gree",
                                     fvarLabels(msn)),
                             drop=FALSE]))

## ----saturation---------------------------------------------------------------
msncor <- requantify(msn,
                     saturationThreshold=1e5,
                     method="sum")

## ----rescaletop3--------------------------------------------------------------
msncor <- rescaleForTop3(before=msn,
                         after=msncor,
                         saturationThreshold=1e5)

## ----sessioninfo--------------------------------------------------------------
sessionInfo()

