/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


/**
 * @file include\apr.h
 * @brief Basic APR header for WIN32
 * @remark This is a Windows specific version of apr.h. It is copied as
 * apr.h at the start of a Windows build.
 */

/**
 * @defgroup APR APR Functions (WIN32)
 * @{
 */

#ifdef WIN32
#ifndef APR_H
#define APR_H

/* Ignore most warnings (back down to /W3) for poorly constructed headers
 */
#if defined(_MSC_VER) && _MSC_VER >= 1200
#pragma warning(push, 3)
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* disable or reduce the frequency of...
 *   C4057: indirection to slightly different base types
 *   C4075: slight indirection changes (unsigned short* vs short[])
 *   C4100: unreferenced formal parameter
 *   C4127: conditional expression is constant
 *   C4201: nonstandard extension nameless struct/unions
 *   C4244: int to char/short - precision loss
 *   C4514: unreferenced inline function removed
 */
#pragma warning(disable: 4100 4127 4201 4514; once: 4057 4075 4244)

#define APR_INLINE __inline
#define APR_HAS_INLINE  	1
#define __attribute__(__x)

#define NO_USE_SIGACTION

#ifndef _WIN32_WCE
#define APR_HAVE_ARPA_INET_H    0
#define APR_HAVE_CONIO_H        1
#define APR_HAVE_CRYPT_H        0
#define APR_HAVE_CTYPE_H        1
#define APR_HAVE_DIRENT_H       0
#define APR_HAVE_ERRNO_H        1
#define APR_HAVE_FCNTL_H        1
#define APR_HAVE_IO_H           1
#define APR_HAVE_LIMITS_H       1
#define APR_HAVE_NETDB_H        0
#define APR_HAVE_NETINET_IN_H   0
#define APR_HAVE_NETINET_TCP_H  0
#define APR_HAVE_PTHREAD_H      0
#define APR_HAVE_SIGNAL_H       1
#define APR_HAVE_STDARG_H       1
#define APR_HAVE_STDINT_H       0
#define APR_HAVE_STDIO_H        1
#define APR_HAVE_STDLIB_H       1
#define APR_HAVE_STRING_H       1
#define APR_HAVE_STRINGS_H      0
#define APR_HAVE_SYS_SENDFILE_H 0
#define APR_HAVE_SYS_SIGNAL_H   0
#define APR_HAVE_SYS_SOCKET_H   0
#define APR_HAVE_SYS_SYSLIMITS_H 0
#define APR_HAVE_SYS_TIME_H     0
#define APR_HAVE_SYS_TYPES_H    1
#define APR_HAVE_SYS_UIO_H      0
#define APR_HAVE_SYS_WAIT_H     0
#define APR_HAVE_UNISTD_H       0
#define APR_HAVE_STDDEF_H       1
#define APR_HAVE_PROCESS_H      1
#define APR_HAVE_TIME_H         1
#else
#define APR_HAVE_ARPA_INET_H    0
#define APR_HAVE_CONIO_H        0
#define APR_HAVE_CRYPT_H        0
#define APR_HAVE_CTYPE_H        0
#define APR_HAVE_DIRENT_H       0
#define APR_HAVE_ERRNO_H        0
#define APR_HAVE_FCNTL_H        0
#define APR_HAVE_IO_H           0
#define APR_HAVE_LIMITS_H       0
#define APR_HAVE_NETDB_H        0
#define APR_HAVE_NETINET_IN_H   0
#define APR_HAVE_NETINET_TCP_H  0
#define APR_HAVE_PTHREAD_H      0
#define APR_HAVE_SIGNAL_H       0
#define APR_HAVE_STDARG_H       0
#define APR_HAVE_STDINT_H       0
#define APR_HAVE_STDIO_H        1
#define APR_HAVE_STDLIB_H       1
#define APR_HAVE_STRING_H       1
#define APR_HAVE_STRINGS_H      0
#define APR_HAVE_SYS_SENDFILE_H 0
#define APR_HAVE_SYS_SIGNAL_H   0
#define APR_HAVE_SYS_SOCKET_H   0
#define APR_HAVE_SYS_SYSLIMITS_H 0
#define APR_HAVE_SYS_TIME_H     0
#define APR_HAVE_SYS_TYPES_H    0
#define APR_HAVE_SYS_UIO_H      0
#define APR_HAVE_SYS_WAIT_H     0
#define APR_HAVE_UNISTD_H       0
#define APR_HAVE_STDDEF_H       0
#define APR_HAVE_PROCESS_H      0
#define APR_HAVE_TIME_H         0
#endif

#define APR_USE_FLOCK_SERIALIZE           0 
#define APR_USE_SYSVSEM_SERIALIZE         0
#define APR_USE_FCNTL_SERIALIZE           0
#define APR_USE_PROC_PTHREAD_SERIALIZE    0 
#define APR_USE_PTHREAD_SERIALIZE         0 

#define APR_HAS_FLOCK_SERIALIZE           0
#define APR_HAS_SYSVSEM_SERIALIZE         0
#define APR_HAS_FCNTL_SERIALIZE           0
#define APR_HAS_PROC_PTHREAD_SERIALIZE    0
#define APR_HAS_RWLOCK_SERIALIZE          0

#define APR_HAS_LOCK_CREATE_NP            0

#define APR_PROCESS_LOCK_IS_GLOBAL        0

#define APR_USES_ANONYMOUS_SHM            0
#define APR_USES_FILEBASED_SHM            0
#define APR_USES_KEYBASED_SHM             0

#define APR_FILE_BASED_SHM      0
#define APR_MEM_BASED_SHM       0

#define APR_HAVE_CORKABLE_TCP   0
#define APR_HAVE_GETRLIMIT      0
#define APR_HAVE_IN_ADDR        1
#define APR_HAVE_INET_ADDR      1
#define APR_HAVE_INET_NETWORK   0
#define APR_HAVE_IPV6           0
#define APR_HAVE_MEMMOVE        1
#define APR_HAVE_SETRLIMIT      0
#define APR_HAVE_SIGACTION      0
#define APR_HAVE_SIGSUSPEND     0
#define APR_HAVE_SIGWAIT        0
#define APR_HAVE_STRCASECMP     0
#define APR_HAVE_STRDUP         1
#define APR_HAVE_STRNCASECMP    0
#define APR_HAVE_STRSTR         1
#define APR_HAVE_MEMCHR         1
#define APR_HAVE_STRUCT_RLIMIT  0
#define APR_HAVE_UNION_SEMUN    0

#ifndef _WIN32_WCE
#define APR_HAVE_STRICMP        1
#define APR_HAVE_STRNICMP       1
#else
#define APR_HAVE_STRICMP        0
#define APR_HAVE_STRNICMP       0
#endif

/* Has windows.h already been included?  If so, our preferences don't matter,
 * but we will still need the winsock things no matter what was included.
 * If not, include a restricted set of windows headers to our tastes.
 */
#ifndef _WINDOWS_
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef _WIN32_WINNT

/* Restrict the server to a subset of Windows NT 4.0 header files by default
 */
#define _WIN32_WINNT 0x0400
#endif
#ifndef NOUSER
#define NOUSER
#endif
#ifndef NOGDI
#define NOGDI
#endif
#ifndef NOMCX
#define NOMCX
#endif
#ifndef NOIME
#define NOIME
#endif
#include <windows.h>
/* 
 * Add a _very_few_ declarations missing from the restricted set of headers
 * (If this list becomes extensive, re-enable the required headers above!)
 * winsock headers were excluded by WIN32_LEAN_AND_MEAN, so include them now
 */
#define SW_HIDE             0
#ifndef _WIN32_WCE
#include <winsock2.h>
#include <mswsock.h>
#else
#include <winsock.h>
#endif
#endif /* !_WINDOWS_ */

#if APR_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if APR_HAVE_STDIO_H
#include <stdio.h>
#endif
#if APR_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if APR_HAVE_STDDEF_H
#include <stddef.h>
#endif
#if APR_HAVE_TIME_H
#include <time.h>
#endif
#if APR_HAVE_PROCESS_H
#include <process.h>
#endif

/*  APR Feature Macros */
#define APR_HAS_SHARED_MEMORY     1
#define APR_HAS_THREADS           1
#define APR_HAS_MMAP              1
#define APR_HAS_FORK              0
#define APR_HAS_RANDOM            1
#define APR_HAS_XLATE             0
#define APR_HAS_OTHER_CHILD       1
#define APR_HAS_DSO               1
#define APR_HAS_SO_ACCEPTFILTER   0
#define APR_HAS_UNICODE_FS        1
#define APR_HAS_PROC_INVOKED      1
#ifndef _WIN32_WCE
#define APR_HAS_SENDFILE          1
#define APR_HAS_USER              1
#define APR_HAS_LARGE_FILES       1
#define APR_HAS_XTHREAD_FILES     1
#else
#define APR_HAS_SENDFILE          0
#define APR_HAS_USER              0
#define APR_HAS_LARGE_FILES       0
#define APR_HAS_XTHREAD_FILES     0
#endif

/* Not all platforms have a real INADDR_NONE.  This macro replaces INADDR_NONE
 * on all platforms.
 */
#define APR_INADDR_NONE           INADDR_NONE

/* This macro indicates whether or not EBCDIC is the native character set.
 */
#define APR_CHARSET_EBCDIC        0

/* Typedefs that APR needs. */

typedef  unsigned char     apr_byte_t;

typedef  short             apr_int16_t;
typedef  unsigned short    apr_uint16_t;
                                               
typedef  int               apr_int32_t;
typedef  unsigned int      apr_uint32_t;
                                               
typedef  __int64           apr_int64_t;
typedef  unsigned __int64  apr_uint64_t;

typedef  size_t      apr_size_t;
#if APR_HAVE_STDDEF_H
typedef  ptrdiff_t   apr_ssize_t;
#else
typedef  int         apr_ssize_t;
#endif
#if APR_HAS_LARGE_FILES
typedef  __int64     apr_off_t;
#else
typedef  int         apr_off_t;
#endif
typedef  int         apr_socklen_t;
typedef  int         pid_t;
typedef  int         uid_t;
typedef  int         gid_t;


/* Mechanisms to properly type numeric literals */

#define APR_INT64_C(val) (val##i64)


/* Definitions that APR programs need to work properly. */

#define APR_THREAD_FUNC          __stdcall

/**
 * APR_DECLARE_EXPORT is defined when building the APR dynamic library,
 * so that all public symbols are exported.
 *
 * APR_DECLARE_STATIC is defined when including the APR public headers,
 * to provide static linkage when the dynamic library may be unavailable.
 *
 * APR_DECLARE_STATIC and APR_DECLARE_EXPORT are left undefined when
 * including the APR public headers, to import and link the symbols from the 
 * dynamic APR library and assure appropriate indirection and calling 
 * conventions at compile time.
 */

#if !defined(WIN32)
/**
 * The public APR functions are declared with APR_DECLARE(), so they may
 * use the most appropriate calling convention.  Public APR functions with 
 * variable arguments must use APR_DECLARE_NONSTD().
 *
 * @deffunc APR_DECLARE(rettype) apr_func(args);
 */
#define APR_DECLARE(type)            type
/**
 * The public APR functions using variable arguments are declared with 
 * AP_DECLARE(), as they must use the C language calling convention.
 *
 * @deffunc APR_DECLARE_NONSTD(rettype) apr_func(args, ...);
 */
#define APR_DECLARE_NONSTD(type)     type
/**
 * The public APR variables are declared with AP_MODULE_DECLARE_DATA.
 * This assures the appropriate indirection is invoked at compile time.
 *
 * @deffunc APR_DECLARE_DATA type apr_variable;
 * @tip extern APR_DECLARE_DATA type apr_variable; syntax is required for
 * declarations within headers to properly import the variable.
 */
#define APR_DECLARE_DATA
#elif defined(APR_DECLARE_STATIC)
#define APR_DECLARE(type)            type __stdcall
#define APR_DECLARE_NONSTD(type)     type
#define APR_DECLARE_DATA
#elif defined(APR_DECLARE_EXPORT)
#define APR_DECLARE(type)            __declspec(dllexport) type __stdcall
#define APR_DECLARE_NONSTD(type)     __declspec(dllexport) type
#define APR_DECLARE_DATA             __declspec(dllexport)
#else
#define APR_DECLARE(type)            __declspec(dllimport) type __stdcall
#define APR_DECLARE_NONSTD(type)     __declspec(dllimport) type
#define APR_DECLARE_DATA             __declspec(dllimport)
#endif

#define APR_SSIZE_T_FMT          "d"

#define APR_SIZE_T_FMT           "d"

#define APR_OFF_T_FMT            "I64d"

/* XXX: Win64 portability problem? */
#define APR_PID_T_FMT            "d"

#define APR_INT64_T_FMT          "I64d"

/* Local machine definition for console and log output. */
#define APR_EOL_STR              "\r\n"

/* No difference between PROC and GLOBAL mutex */
#define APR_PROC_MUTEX_IS_GLOBAL      1

typedef int apr_wait_t;

/* struct iovec is needed to emulate Unix writev */
struct iovec {
    char*  iov_base;
    size_t iov_len;
};

/* Nasty Win32 .h ommissions we really need */
#define STDIN_FILENO  0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2

#if APR_HAS_UNICODE_FS
/* An arbitrary size that is digestable. True max is a bit less than 32000 */
#define APR_PATH_MAX 8192
#else /* !APR_HAS_UNICODE_FS */
#define APR_PATH_MAX MAX_PATH
#endif

#ifdef __cplusplus
}
#endif

/* Done with badly written headers
 */
#if defined(_MSC_VER) && _MSC_VER >= 1200
#pragma warning(pop)
#endif

#endif /* APR_H */

#endif /* WIN32 */
/** @} */
