/**
   SSLConn.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu May  6 22:26:01 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLConn.java,v 1.6 1999/06/22 06:24:53 ekr Exp $

*/


package COM.claymoresystems.ptls;
import COM.claymoresystems.sslg.*;
import java.util.Vector;
import java.net.*;
import java.io.*;

class SSLConn {
     static final int SSL_CLIENT = 1;
     static final int SSL_SERVER = 2;


//     static int debugVal=DEBUG_CRYPTO;
     static int debugVal=0;
     
     /* Connection Housekeeping*/
     int ssl_version=0;	// SSLv3
     SSLContext ctx;
     Socket s;
     SSLPolicyInt policy;	// The policy we're following
     InputStream sock_in;       // The stream to do our raw reading on
     InputStream sock_in_hp;	// The stream for handshake messages
     InputStream sock_in_data;	// The stream for app data;

     OutputStream sock_out; // The stream to do our raw writing on
     OutputStream sock_out_external; // The stream to expose
     boolean sentClose=false;
     boolean recvdClose=false;
     Vector peerCertificateChain=null;
     String sessionLookupKey=null;
     int how;
     
     // Our cipher states
     SSLCipherState write_cipher_state=null;
     SSLCipherState read_cipher_state=null;
     SSLCipherState next_write_cipher_state;
     SSLCipherState next_read_cipher_state;
     long write_sequence_num;
     long read_sequence_num;
     
     SSLHandshake hs;	    // The handshake object
     SSLRecordReader rdr;   // The record reader

     SSLConn(Socket sock,InputStream in,OutputStream out,SSLContext c,int how)
       throws java.io.IOException {
       this.s=sock;
       this.how=how;
       ctx=c;
       policy=c.getPolicy();
       sock_in=in;
       sock_out=out;

       //Set up the streams for reading different record types
       SSLRecordReader rdr=new SSLRecordReader(this);
     }  

     void renegotiate(SSLPolicyInt p)
       throws IOException {
       policy=p;

       handshake();
     }
     
     void handshake()
       throws IOException {
       ssl_version=policy.negotiateTLSP()?SSLHandshake.TLS_V1_VERSION:SSLHandshake.SSL_V3_VERSION;
       
       if(how == SSL_CLIENT){
	 hs=new SSLHandshakeClient(this);
       }
       else{
	 hs=new SSLHandshakeServer(this);
       }
       
       hs.handshake();
     }
     
     int getCipherSuite()
       throws IOException {
       if(!hs.finishedP()){
	 throw new SSLException("Handshake not finished");
       }

       return write_cipher_state.cipher_suite.getValue();
     }

     SSLPolicyInt getPolicy(){
       return policy;
     }

     int getVersion()
       throws IOException {
       if(!hs.finishedP()){
	 throw new SSLException("Handshake not finished");
       }

       return ssl_version;
     }

     Vector getCertificateChain()
       throws IOException {
       if(!hs.finishedP()){
	 throw new SSLException("Handshake not finished");
       }
       
       return peerCertificateChain;
     }

     void alert(int a)
       throws java.io.IOException {
       alert(a,true);

       throw new SSLThrewAlertException(new SSLAlertX(ssl_version,a,
	 true));
     }


     void alert(int a,boolean fatal)
       throws java.io.IOException {
       SSLAlertX alertx=new SSLAlertX(ssl_version,a,fatal);
       SSLAlert alert=new SSLAlert(alertx);
       ByteArrayOutputStream bos=new ByteArrayOutputStream();
       alert.encode(this,bos);

       SSLRecord r=new SSLRecord(this,SSLRecord.SSL_CT_ALERT,
	 bos.toByteArray());
       r.send(this);
     }

     void processHelloRequest()
       throws IOException {
       if(how!=SSL_CLIENT) alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
       if(!hs.finishedP()) alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);

       throw new SSLReHandshakeException();
     }
     
     static void debug(int type,String val){
       if((debugVal & type) > 0){
	 System.out.println(val);
       }
     }

     static void debug(int type,String label,byte[] hd){
       if((debugVal & type) > 0){
	 COM.claymoresystems.util.Util.xdump(label,hd);
       }
     }

     InputStream getInStream(){
       return sock_in_data;
     }

     OutputStream getOutStream(){
       return sock_out_external;
     }

     void makeUnresumable(){
       if(sessionLookupKey!=null)
	 ctx.destroySession(sessionLookupKey);
     }

     void sendClose()
       throws java.io.IOException {
       if(!sentClose){
	 alert(SSLAlertX.TLS_ALERT_CLOSE_NOTIFY,false);
	 sentClose=true;
       }
     }	 

     void recvClose(boolean enforceFinished)
       throws java.io.IOException {
       InputStream in=getInStream();
       byte[] buf=new byte[1024];

       // Flush the in buffer until we hit a closed or a
       // FIN
       while(in.read(buf)>=0){
	 if(enforceFinished){
	   throw new SSLException("Excess data in pipe when closed");
	 }
       }
     }

     void close()
       throws java.io.IOException {
       sendClose();
       recvClose(false);
     }

     public static void setDebug(int flag){
       debugVal=flag;
     }
}
