#include "set.h"

#include "asndata.def"

void main()
{
	ofile os( "rca_cs.ber" ) ;

	Certificate c ;

	c.cert().version().set( Version::v3 ) ;
	c.cert().serialNumber().set( 65536 ) ;
	c.cert().signature().set( sha1WithRsaSignature ) ;
	Name nm ;
	nm.set( id_at_countryName, PrintableString( "ES" ) ) ;
	nm.set( id_at_organization, PrintableString( "Name of organization responsible for the Root Certificate" ) ) ;
	c.cert().issuer().set( nm ) ;
	c.cert().validity().notBefore().set( time(0) ) ;
	c.cert().validity().notAfter().set( Asn1Time::offset( time(0), 1 ) ) ;
	c.cert().subject().set( nm ) ;
	c.cert().subjectPublicKeyInfo().algorithm().set( sha1WithRsaSignature ) ;
	c.cert().subjectPublicKeyInfo().subjectPublicKeyBits().set( "'3068026100BEAA8B7754A3AFCA779F2FB0CF4388FFA66D79555B618C68EC481E8A8638A4FE19B862171D9D0F472CFF638F299104D152BC7F67B6B28F7455C133216C8FAB019524C8B273939D226150A935FB9D575032EF56525093ABB18894785615C61C8B0203010001'H" ) ;
	c.signatureAlgorithm().set( sha1WithRsaSignature ) ;
	c.signature().set( "'5C01BDB54188877A0ED30E6B3ABF04EA04CB5F61723CA3BD78F56617FE373AABEB67BFB7DAA838F6331571752FB98C91A0E487BA4B43A0228FD3A9864389E6505C01BDB54188877A0ED30E6B3ABF04EA04CB5F61723CA3BD78F56617FE373AABEB67BFB7DAA838F6331571752FB98C91A0E487BA4B43A0228FD3A9864389E650'H" ) ;

	// extensions

	c.cert().extensions(1).set( id_ce_keyUsage, KeyUsage( KeyUsage::cRLSign ), TRUE ) ;

	PrivateKeyUsagePeriod pku ;
	pku.notBefore().set( Asn1Time::offset( time(0), -1 ) ) ;
	pku.notAfter().set( Asn1Time::offset( time(0), 1 ) ) ;
	c.cert().extensions(2).set( id_ce_privateKeyUsagePeriod, pku, TRUE ) ;

	CertificatePoliciesSyntax pols ; // mere example id
	pols.policyInformation(0).policyIdentifier().set( ObjectIdentifier( 1, 2, 65536 ) ) ;
	c.cert().extensions(3).set( id_ce_certificatePolicies, pols ) ;

	GeneralNames gn ;
	gn.generalName(0).rfc822Name().set( "root@domain.es" ) ;
	gn.generalName(1).uniformResourceIdentifier().set( "http://www.domain.es/" ) ;
	c.cert().extensions(4).set( id_ce_subjectAltName, gn ) ;

	BasicConstraintsSyntax bs ;
	bs.cA().set( TRUE ) ;
	c.cert().extensions(5).set( id_ce_basicConstraints, bs, TRUE ) ;

	CertificateTypeSyntax ct ;
	ct.set( CertificateTypeSyntax::rca ) ;
	c.cert().extensions(7).set( id_set_certificateType, ct, TRUE ) ;

	c.encode( os ) ;
}
