/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.management;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.credential.store.api.CredentialMetadata;
import org.apache.custos.core.credential.store.api.GetCredentialRequest;
import org.apache.custos.core.credential.store.api.Type;
import org.apache.custos.core.federated.authentication.api.ClientMetadata;
import org.apache.custos.core.federated.authentication.api.RegisterClientResponse;
import org.apache.custos.core.iam.api.ConfigureFederateIDPRequest;
import org.apache.custos.core.iam.api.FederatedIDPs;
import org.apache.custos.core.iam.api.SetUpTenantRequest;
import org.apache.custos.core.iam.api.SetUpTenantResponse;
import org.apache.custos.core.task.ServiceException;
import org.apache.custos.core.task.ServiceTaskImpl;
import org.apache.custos.core.tenant.profile.api.GetTenantRequest;
import org.apache.custos.core.tenant.profile.api.GetTenantResponse;
import org.apache.custos.core.tenant.profile.api.Tenant;
import org.apache.custos.core.tenant.profile.api.TenantStatus;
import org.apache.custos.core.tenant.profile.api.UpdateStatusRequest;
import org.apache.custos.core.tenant.profile.api.UpdateStatusResponse;
import org.apache.custos.service.credential.store.CredentialStoreService;
import org.apache.custos.service.federated.cilogon.FederatedAuthenticationService;
import org.apache.custos.service.iam.IamAdminService;
import org.apache.custos.service.profile.TenantProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TenantActivationTask<T, U>
extends ServiceTaskImpl<T, U> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantActivationTask.class);
    private final IamAdminService iamAdminService;
    private final FederatedAuthenticationService federatedAuthentication;
    private final CredentialStoreService credentialStoreService;
    private final TenantProfileService tenantProfileService;
    @Value(value="${spring.profiles.active}")
    private String activeProfile;

    public TenantActivationTask(IamAdminService iamAdminService, FederatedAuthenticationService federatedAuthentication, CredentialStoreService credentialStoreService, TenantProfileService tenantProfileService) {
        this.iamAdminService = iamAdminService;
        this.federatedAuthentication = federatedAuthentication;
        this.credentialStoreService = credentialStoreService;
        this.tenantProfileService = tenantProfileService;
    }

    public void invokeService(T data) {
        try {
            if (data instanceof UpdateStatusResponse) {
                long tenantId = ((UpdateStatusResponse)data).getTenantId();
                LOGGER.debug("Invoking tenant activation task for tenant " + tenantId);
                GetTenantRequest tenantRequest = GetTenantRequest.newBuilder().setTenantId(tenantId).build();
                GetTenantResponse tenantRes = this.tenantProfileService.getTenant(tenantRequest);
                Tenant tenant = tenantRes.getTenant();
                if (tenant != null) {
                    GetCredentialRequest request = GetCredentialRequest.newBuilder().setId(tenant.getAdminUsername()).setOwnerId(tenantId).setType(Type.INDIVIDUAL).build();
                    CredentialMetadata metadata = this.credentialStoreService.getCredential(request);
                    if (metadata != null && metadata.getSecret() != null) {
                        Tenant newTenant = tenant.toBuilder().setAdminPassword(metadata.getSecret()).build();
                        GetCredentialRequest iamClientRequest = GetCredentialRequest.newBuilder().setOwnerId(tenantId).setType(Type.IAM).build();
                        CredentialMetadata iamMetadata = this.credentialStoreService.getCredential(iamClientRequest);
                        UpdateStatusResponse response = iamMetadata == null || iamMetadata.getId() == null || StringUtils.isBlank((CharSequence)iamMetadata.getId()) ? this.activateTenant(newTenant, "SYSTEM", false) : this.activateTenant(newTenant, "SYSTEM", true);
                        this.invokeNextTask(response);
                    } else {
                        String msg = "Admin password not found  for admin  " + tenant.getAdminUsername();
                        LOGGER.error(msg);
                        this.getServiceCallback().onError(new ServiceException(msg, null, null));
                    }
                } else {
                    String msg = "Tenant not found  for Id  " + tenantId;
                    LOGGER.error(msg);
                    this.getServiceCallback().onError(new ServiceException(msg, null, null));
                }
            } else {
                String msg = "Invalid payload type ";
                LOGGER.error(msg);
                this.getServiceCallback().onError(new ServiceException(msg, null, null));
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred  " + String.valueOf(ex.getCause());
            LOGGER.error(msg, (Throwable)ex);
            this.getServiceCallback().onError(new ServiceException(msg, ex.getCause(), null));
        }
    }

    public UpdateStatusResponse activateTenant(Tenant tenant, String performedBy, boolean update) {
        GetCredentialRequest getCreRe = GetCredentialRequest.newBuilder().setOwnerId(tenant.getTenantId()).setType(Type.CUSTOS).build();
        CredentialMetadata metadata = this.credentialStoreService.getCredential(getCreRe);
        SetUpTenantRequest setUpTenantRequest = SetUpTenantRequest.newBuilder().setTenantId(tenant.getTenantId()).setTenantName(tenant.getClientName()).setAdminFirstname(tenant.getAdminFirstName()).setAdminLastname(tenant.getAdminLastName()).setAdminEmail(tenant.getAdminEmail()).addAllRedirectURIs((Iterable)tenant.getRedirectUrisList()).setAdminPassword(tenant.getAdminPassword()).setAdminUsername(tenant.getAdminUsername()).setRequesterEmail(tenant.getRequesterEmail()).setTenantURL(tenant.getClientUri()).setCustosClientId(metadata.getId()).build();
        SetUpTenantResponse iamResponse = update ? this.iamAdminService.updateTenant(setUpTenantRequest) : this.iamAdminService.setUPTenant(setUpTenantRequest);
        CredentialMetadata credentialMetadata = CredentialMetadata.newBuilder().setId(iamResponse.getClientId()).setSecret(iamResponse.getClientSecret()).setOwnerId(tenant.getTenantId()).setType(Type.IAM).build();
        this.credentialStoreService.putCredential(credentialMetadata);
        String comment = tenant.getComment() == null || tenant.getComment().trim().isEmpty() ? "Created by CUSTOS " : tenant.getComment();
        String[] scopes = tenant.getScope() != null ? tenant.getScope().split(" ") : new String[]{};
        GetCredentialRequest credentialRequest = GetCredentialRequest.newBuilder().setOwnerId(tenant.getTenantId()).setType(Type.CILOGON).build();
        String ciLogonRedirectURI = this.iamAdminService.getIamServerURL() + "realms/" + tenant.getTenantId() + "/broker/oidc/endpoint";
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        arrayList.add((CallSite)((Object)ciLogonRedirectURI));
        ClientMetadata.Builder clientMetadataBuilder = ClientMetadata.newBuilder().setTenantId(tenant.getTenantId()).setTenantName(tenant.getClientName()).setTenantURI(tenant.getClientUri()).setComment(comment).addAllScope(Arrays.asList(scopes)).addAllRedirectURIs(arrayList).addAllContacts((Iterable)tenant.getContactsList()).setPerformedBy(performedBy);
        CredentialMetadata creMeta = this.credentialStoreService.getCredential(credentialRequest);
        clientMetadataBuilder.setClientId(creMeta.getId());
        if (!update && !this.activeProfile.equalsIgnoreCase("local")) {
            RegisterClientResponse registerClientResponse = this.federatedAuthentication.addClient(clientMetadataBuilder.build());
            CredentialMetadata credentialMetadataCILogon = CredentialMetadata.newBuilder().setId(registerClientResponse.getClientId()).setSecret(registerClientResponse.getClientSecret()).setOwnerId(tenant.getTenantId()).setType(Type.CILOGON).build();
            this.credentialStoreService.putCredential(credentialMetadataCILogon);
            ConfigureFederateIDPRequest request = ConfigureFederateIDPRequest.newBuilder().setTenantId(tenant.getTenantId()).setClientID(registerClientResponse.getClientId()).setClientSec(registerClientResponse.getClientSecret()).setScope(tenant.getScope()).setRequesterEmail(tenant.getRequesterEmail()).setType(FederatedIDPs.CILOGON).build();
            this.iamAdminService.configureFederatedIDP(request);
        }
        UpdateStatusRequest updateTenantRequest = UpdateStatusRequest.newBuilder().setTenantId(tenant.getTenantId()).setStatus(TenantStatus.ACTIVE).setUpdatedBy("SYSTEM").build();
        return this.tenantProfileService.updateTenantStatus(updateTenantRequest);
    }
}

