/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.text.translate.LookupTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LookupTranslatorTest {
    LookupTranslatorTest() {
    }

    @Test
    void testBasicLookup() throws IOException {
        HashMap<String, String> translatorMap = new HashMap<String, String>();
        translatorMap.put("one", "two");
        LookupTranslator lt = new LookupTranslator(translatorMap);
        StringWriter out = new StringWriter();
        int result = lt.translate((CharSequence)"one", 0, (Writer)out);
        Assertions.assertEquals((int)3, (int)result, (String)"Incorrect code point consumption");
        Assertions.assertEquals((Object)"two", (Object)out.toString(), (String)"Incorrect value");
    }

    @Test
    void testFailsToCreateLookupTranslatorThrowsInvalidParameterException() {
        Assertions.assertThrowsExactly(NullPointerException.class, () -> new LookupTranslator(null));
    }

    @Test
    void testLang882() throws IOException {
        HashMap<StringBuffer, StringBuffer> translatorMap = new HashMap<StringBuffer, StringBuffer>();
        translatorMap.put(new StringBuffer("one"), new StringBuffer("two"));
        LookupTranslator lt = new LookupTranslator(translatorMap);
        StringWriter out = new StringWriter();
        int result = lt.translate((CharSequence)new StringBuffer("one"), 0, (Writer)out);
        Assertions.assertEquals((int)3, (int)result, (String)"Incorrect code point consumption");
        Assertions.assertEquals((Object)"two", (Object)out.toString(), (String)"Incorrect value");
    }

    @Test
    void testTranslateSupplementaryCharacter() {
        String symbol = new StringBuilder().appendCodePoint(120120).toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(symbol, "A");
        LookupTranslator translator = new LookupTranslator(map);
        String translated = translator.translate((CharSequence)(symbol + "=A"));
        Assertions.assertEquals((Object)"A=A", (Object)translated, (String)"Incorrect value");
    }
}

