/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionForceConsumerDelivery
extends PacketImpl {
    private long consumerID;
    private long sequence;

    public SessionForceConsumerDelivery(long consumerID, long sequence) {
        super((byte)78);
        this.consumerID = consumerID;
        this.sequence = sequence;
    }

    public SessionForceConsumerDelivery() {
        super((byte)78);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.sequence);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.sequence = buffer.readLong();
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", consumerID=" + this.consumerID);
        sb.append(", sequence=" + this.sequence);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumerID, this.sequence);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionForceConsumerDelivery)) {
            return false;
        }
        SessionForceConsumerDelivery other = (SessionForceConsumerDelivery)obj;
        return this.consumerID == other.consumerID && this.sequence == other.sequence;
    }
}

