/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.runtime1.layers.LayerDriver;
import org.apache.daffodil.runtime1.layers.LayerDriver$;
import org.apache.daffodil.runtime1.processors.SequenceRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.OrderedUnseparatedSequenceParser;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.SequenceChildParser;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class LayeredSequenceParser
extends OrderedUnseparatedSequenceParser {
    private final SequenceRuntimeData rd;

    public LayeredSequenceParser(SequenceRuntimeData rd, SequenceChildParser bodyParser) {
        this.rd = rd;
        super(rd, new SequenceChildParser[]{bodyParser});
    }

    @Override
    public String nom() {
        return "LayeredSequence";
    }

    @Override
    public void parse(PState state) {
        LayerDriver layerDriver = null;
        InputSourceDataInputStream savedDIS = state.dataInputStream();
        try {
            layerDriver = LayerDriver$.MODULE$.apply(state, this.rd.layerRuntimeData());
            layerDriver.init();
            boolean isAligned = savedDIS.align(layerDriver.mandatoryLayerAlignmentInBits(), state);
            if (!isAligned) {
                this.PE(state, "Unable to align to the mandatory layer alignment of %s(bits)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)layerDriver.mandatoryLayerAlignmentInBits())}));
            }
            InputSourceDataInputStream newDIS = layerDriver.addInputLayer(savedDIS);
            try {
                state.dataInputStream_$eq(newDIS);
                super.parse(state);
            }
            finally {
                try {
                    layerDriver.removeInputLayer(newDIS);
                }
                finally {
                    state.dataInputStream_$eq(savedDIS);
                }
            }
        }
        catch (Throwable throwable) {
            Nothing$ nothing$;
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3;
                Throwable t = throwable3 = throwable2;
                if (layerDriver != null) {
                    nothing$ = layerDriver.handleThrowable(t);
                } else {
                    Throwable t2 = throwable3;
                    nothing$ = LayerDriver$.MODULE$.handleThrowableWithoutLayer(t2);
                }
            } else {
                throw throwable;
            }
            throw nothing$;
        }
    }
}

