/*
 * Decompiled with CFR 0.152.
 */
package grails.dev.commands.io;

import grails.dev.commands.io.FileSystemInteraction;
import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.io.support.DefaultResourceLoader;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.PathMatchingResourcePatternResolver;
import org.grails.io.support.Resource;
import org.grails.io.support.ResourceLoader;
import org.grails.io.support.ResourceLocator;
import org.grails.io.support.SpringIOUtils;

public class FileSystemInteractionImpl
implements FileSystemInteraction,
GroovyObject {
    private File baseDir;
    private ResourceLoader resourceLoader;
    private PathMatchingResourcePatternResolver resourcePatternResolver;
    private ResourceLocator resourceLocator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public FileSystemInteractionImpl(File baseDir, ResourceLoader resourceLoader) {
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver;
        ResourceLocator resourceLocator;
        ResourceLoader resourceLoader2;
        File file;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.baseDir = file = baseDir;
        this.resourceLoader = resourceLoader2 = resourceLoader;
        this.resourceLocator = resourceLocator = new ResourceLocator();
        this.resourceLocator.setSearchLocation(baseDir.getAbsolutePath());
        this.resourcePatternResolver = pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver(resourceLoader);
    }

    @Generated
    public FileSystemInteractionImpl(File baseDir) {
        this(baseDir, (ResourceLoader)((Object)IndyInterface.bootstrap("init", "<init>", 0, DefaultResourceLoader.class)));
    }

    @Override
    public FileSystemInteractionImpl mkdir(Object path) {
        File file = this.file(path);
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        return this;
    }

    @Override
    public FileSystemInteractionImpl delete(Object path) {
        File file = this.file(path);
        Boolean bl = file != null ? Boolean.valueOf(file.delete()) : null;
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(@DelegatesTo(value=FileSystemInteraction.CopySpec.class) Closure callable) {
        FileSystemInteraction.CopySpec spec = new FileSystemInteraction.CopySpec();
        FileSystemInteraction.CopySpec copySpec = spec;
        callable.setDelegate(copySpec);
        callable.call();
        if (DefaultTypeTransformation.booleanUnbox(spec.getFrom()) && DefaultTypeTransformation.booleanUnbox(spec.getInto())) {
            if (spec.getFrom() instanceof Iterable) {
                this.copyAll((Iterable)((Object)IndyInterface.bootstrap("cast", "()", 0, spec.getFrom())), spec.getInto());
            } else {
                this.copy(spec.getFrom(), spec.getInto());
            }
        }
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(Object path, Object destination) {
        Resource from = this.resource(path);
        File to = this.file(destination);
        this.copy(from, to);
        return this;
    }

    @Override
    public FileSystemInteractionImpl copyAll(Iterable resources, Object destination) {
        this.mkdir(destination);
        Iterable iterable = resources;
        Object path = null;
        Iterator iterator = iterable != null ? iterable.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                path = iterator.next();
                Resource from = this.resource(path);
                File to = this.file(destination);
                this.copy(from, to);
            }
        }
        return this;
    }

    @Override
    public FileSystemInteractionImpl copy(Resource from, File to) {
        File file = to;
        Boolean bl = file != null ? Boolean.valueOf(file.exists()) : null;
        if (!(bl == null ? false : bl)) {
            this.mkdir(to);
        }
        if (DefaultTypeTransformation.booleanUnbox(from) && DefaultTypeTransformation.booleanUnbox(to)) {
            if (to.isDirectory()) {
                this.mkdir(to);
                to = new File(to, from.getFilename());
            }
            SpringIOUtils.copy(from, to);
            DefaultGroovyMethods.println((Object)this, (Object)new GStringImpl(new Object[]{from.getFilename(), to.getCanonicalPath()}, new String[]{"Copied ", " to location ", ""}));
        }
        return this;
    }

    @Override
    public File file(Object path) {
        if (path instanceof File) {
            return IndyInterface.bootstrap("cast", "()", 0, path);
        }
        if (path instanceof Resource) {
            return IndyInterface.bootstrap("cast", "()", 0, path).getFile();
        }
        File file = this.baseDir;
        return new File(IndyInterface.bootstrap("cast", "()", 0, file) != false ? file : new File("."), DefaultGroovyMethods.toString(path));
    }

    @Override
    public File getBuildDir() {
        return BuildSettings.TARGET_DIR;
    }

    @Override
    public File getResourcesDir() {
        return BuildSettings.RESOURCES_DIR;
    }

    @Override
    public File getClassesDir() {
        return BuildSettings.CLASSES_DIR;
    }

    @Override
    public Resource source(String className) {
        return this.resourceLocator.findResourceForClassName(className);
    }

    @Override
    public String className(Resource resource) {
        return GrailsResourceUtils.getClassName(resource);
    }

    @Override
    public Resource resource(Object path) {
        Object object = path;
        if ((object == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, object)) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (path instanceof Resource) {
            return IndyInterface.bootstrap("cast", "()", 0, path);
        }
        File f = this.file(path);
        File file = f;
        if (DefaultTypeTransformation.booleanUnbox(file != null ? Boolean.valueOf(file.exists()) : null) && f.isFile()) {
            return new FileSystemResource(f);
        }
        String pathStr = DefaultGroovyMethods.toString(path);
        Resource resource = this.resourceLoader.getResource(pathStr);
        if (resource.exists()) {
            return resource;
        }
        Collection<Resource> allResources = this.resources(pathStr);
        Collection<Resource> collection = allResources;
        if ((collection == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, collection)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(allResources, 0));
        }
        return resource;
    }

    @Override
    public Collection<Resource> resources(String pattern) {
        List<Resource> list = DefaultGroovyMethods.toList(this.resourcePatternResolver.getResources(pattern));
        try {
            return list;
        }
        catch (Exception e) {
            List list2 = ScriptBytecodeAdapter.createList(new Object[0]);
            return list2;
        }
    }

    @Override
    public String projectPath(Object path) {
        File file = this.file(path);
        File file2 = file;
        if ((file2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, file2)) != false) {
            String basePath = this.baseDir.getCanonicalPath();
            return StringGroovyMethods.minus((CharSequence)file.getCanonicalPath(), basePath).substring(1);
        }
        return "";
    }

    @Override
    public Collection<File> files(String pattern) {
        public final class _files_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _files_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public File doCall(Resource res) {
                return res.getFile();
            }

            @Generated
            public File call(Resource res) {
                return this.doCall(res);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _files_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.collect(this.resources(pattern), new _files_closure1(this, this));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSystemInteractionImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public File getBaseDir() {
        return this.baseDir;
    }

    @Generated
    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Generated
    public PathMatchingResourcePatternResolver getResourcePatternResolver() {
        return this.resourcePatternResolver;
    }

    @Generated
    public void setResourcePatternResolver(PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver) {
        this.resourcePatternResolver = pathMatchingResourcePatternResolver;
    }

    @Generated
    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Generated
    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }
}

