/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.hateoas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.http.hateoas.GenericResource;
import io.micronaut.http.hateoas.Link;

@Introspected
public interface Resource {
    public static final String LINKS = "_links";
    public static final String EMBEDDED = "_embedded";

    @JsonProperty(value="_links")
    default public OptionalMultiValues<? extends Link> getLinks() {
        return OptionalMultiValues.empty();
    }

    @JsonProperty(value="_embedded")
    default public OptionalMultiValues<? extends Resource> getEmbedded() {
        return OptionalMultiValues.empty();
    }

    @Internal
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Resource deserialize(GenericResource genericResource) {
        return genericResource;
    }
}

