/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.util.Locale;
import org.apache.hc.core5.annotation.Internal;

public final class TextUtils {
    private TextUtils() {
    }

    public static boolean isEmpty(CharSequence s) {
        return TextUtils.length(s) == 0;
    }

    public static boolean isBlank(CharSequence s) {
        int strLen = TextUtils.length(s);
        if (strLen == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean containsBlanks(CharSequence s) {
        int strLen = TextUtils.length(s);
        if (strLen == 0) {
            return false;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (!Character.isWhitespace(s.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int unsignedB = element & 0xFF;
            if (unsignedB < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(unsignedB));
        }
        return buffer.toString();
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.ROOT);
    }

    public static boolean isAllASCII(CharSequence s) {
        int strLen = TextUtils.length(s);
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (s.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Internal
    public static byte castAsByte(int c) {
        if (c >= 32 && c <= 126 || c >= 160 && c <= 255 || c == 9) {
            return (byte)c;
        }
        return 63;
    }
}

