/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.database.GormOneOfFeature;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.Options;

@Singleton
public class Neo4jGorm
extends GormOneOfFeature {
    @Override
    public String getName() {
        return "gorm-neo4j";
    }

    @Override
    public String getTitle() {
        return "GORM for Neo4j";
    }

    @Override
    public String getDescription() {
        return "Configure GORM for using Neo4j";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationConfiguration config = generatorContext.getConfiguration();
        this.applyDefaultGormConfig(config);
        config.put("grails.neo4j.type", "embedded");
        config.put("grails.neo4j.location", "build/data/neo4j");
        generatorContext.addDependency(Dependency.builder().groupId("org.grails.plugins").artifactId("neo4j").implementation());
        generatorContext.addDependency(Dependency.builder().groupId("org.neo4j.test").artifactId("neo4j-harness").testRuntimeOnly());
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return selectedFeatures.stream().anyMatch(f -> f instanceof Neo4jGorm) || options.getGormImpl() == GormImpl.NEO4J;
    }
}

